/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.TraitPartType;
import io.github.sefiraat.slimetinker.infinitylib.common.StackUtils;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterialManager;
import io.github.sefiraat.slimetinker.items.tinkermaterials.recipes.MoltenResult;
import io.github.sefiraat.slimetinker.modifiers.Mod;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.GeneralUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class ItemUtils {
    private ItemUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void incrementRepair(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        Damageable damageable = (Damageable)im;
        assert (damageable != null);
        damageable.setDamage(Math.max(damageable.getDamage() - 1, 0));
        itemStack.setItemMeta(im);
    }

    public static void incrementRepair(@Nonnull ItemStack itemStack, int amount) {
        ItemMeta im = itemStack.getItemMeta();
        Damageable damageable = (Damageable)im;
        assert (damageable != null);
        damageable.setDamage(Math.max(damageable.getDamage() - amount, 0));
        itemStack.setItemMeta(im);
    }

    @Nullable
    public static String getItemName(ItemStack itemStack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (slimefunItem == null) {
            if (!itemStack.hasItemMeta()) {
                return itemStack.getType().toString();
            }
        } else {
            return slimefunItem.getId();
        }
        return null;
    }

    @Nullable
    public static String getToolMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        if (im == null) {
            return null;
        }
        PersistentDataContainer c = im.getPersistentDataContainer();
        if (!c.has(Keys.TOOL_INFO_HEAD_MATERIAL, PersistentDataType.STRING)) {
            return null;
        }
        return (String)c.get(Keys.TOOL_INFO_HEAD_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getArmourMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        if (im == null) {
            return null;
        }
        PersistentDataContainer c = im.getPersistentDataContainer();
        if (!c.has(Keys.ARMOUR_INFO_PLATE_MATERIAL, PersistentDataType.STRING)) {
            return null;
        }
        return (String)c.get(Keys.ARMOUR_INFO_PLATE_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getPartMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        if (im == null) {
            return null;
        }
        PersistentDataContainer c = im.getPersistentDataContainer();
        if (!c.has(Keys.PART_MATERIAL, PersistentDataType.STRING)) {
            return null;
        }
        return (String)c.get(Keys.PART_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getPartClass(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return im == null ? null : PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_CLASS);
    }

    public static boolean partIsTool(@Nonnull String partClass) {
        return partClass.equals("HEAD") || partClass.equals("BINDING") || partClass.equals("ROD");
    }

    public static boolean partIsArmour(@Nonnull String partClass) {
        return partClass.equals("PLATE") || partClass.equals("GAMBESON") || partClass.equals("LINKS");
    }

    @Nullable
    public static String getPartType(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return im == null ? null : PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_TYPE);
    }

    public static void rebuildTinkerLore(@Nonnull ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            ItemUtils.rebuildToolLore(itemStack);
        } else if (ItemUtils.isArmour(itemStack)) {
            ItemUtils.rebuildArmourLore(itemStack);
        }
    }

    private static void rebuildToolLore(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        ArrayList<Object> lore = new ArrayList<Object>();
        String matHead = ItemUtils.getToolHeadMaterial(c);
        String matBind = ItemUtils.getToolBindingMaterial(c);
        String matRod = ItemUtils.getToolRodMaterial(c);
        lore.add(ThemeUtils.getLine());
        lore.add(ThemeUtils.CLICK_INFO + "H: " + ItemUtils.formatMaterialName(matHead));
        lore.add(ThemeUtils.CLICK_INFO + "B: " + ItemUtils.formatMaterialName(matBind));
        lore.add(ThemeUtils.CLICK_INFO + "R: " + ItemUtils.formatMaterialName(matRod));
        lore.add(ThemeUtils.getLine());
        lore.add(ItemUtils.formatPropertyName(matHead, TinkerMaterialManager.getTraitName(matHead, TraitPartType.HEAD)));
        lore.add(ItemUtils.formatPropertyName(matBind, TinkerMaterialManager.getTraitName(matBind, TraitPartType.BINDER)));
        lore.add(ItemUtils.formatPropertyName(matRod, TinkerMaterialManager.getTraitName(matRod, TraitPartType.ROD)));
        lore.add(ThemeUtils.getLine());
        lore.add(ItemUtils.getLoreExp(c));
        lore.add(ItemUtils.getLoreModSlots(c));
        lore.add(ThemeUtils.getLine());
        Map<String, Integer> mapAmounts = Modifications.getModificationMapTool(itemStack);
        Map<String, Integer> mapLevels = Modifications.getAllModLevels(itemStack);
        for (Map.Entry<String, Integer> entry : mapLevels.entrySet()) {
            int level = entry.getValue();
            Mod mod = Modifications.getModificationDefinitionsTool().get(entry.getKey());
            if (mod.getRequirementMap().containsKey(level + 1)) {
                String amountRequired = String.valueOf(mod.getRequirementMap().get(level + 1));
                lore.add(ThemeUtils.CLICK_INFO + ThemeUtils.toTitleCase(entry.getKey()) + " Level " + entry.getValue() + ThemeUtils.PASSIVE + " - (" + mapAmounts.get(entry.getKey()) + "/" + amountRequired + ")");
                continue;
            }
            lore.add(ThemeUtils.CLICK_INFO + ThemeUtils.toTitleCase(entry.getKey()) + " Level " + entry.getValue() + ThemeUtils.PASSIVE + " - (MAX)");
        }
        if (!mapLevels.isEmpty()) {
            lore.add(ThemeUtils.getLine());
        }
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }

    public static void rebuildArmourLore(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        ArrayList<Object> lore = new ArrayList<Object>();
        String matPlate = ItemUtils.getArmourPlateMaterial(c);
        String matGambeson = ItemUtils.getArmourGambesonMaterial(c);
        String matLinks = ItemUtils.getArmourLinksMaterial(c);
        lore.add(ThemeUtils.getLine());
        lore.add(ThemeUtils.CLICK_INFO + "P: " + ItemUtils.formatMaterialName(matPlate));
        lore.add(ThemeUtils.CLICK_INFO + "G: " + ItemUtils.formatMaterialName(matGambeson));
        lore.add(ThemeUtils.CLICK_INFO + "L: " + ItemUtils.formatMaterialName(matLinks));
        lore.add(ThemeUtils.getLine());
        lore.add(ItemUtils.formatPropertyName(matPlate, TinkerMaterialManager.getTraitName(matPlate, TraitPartType.PLATES)));
        lore.add(ItemUtils.formatPropertyName(matGambeson, TinkerMaterialManager.getTraitName(matGambeson, TraitPartType.GAMBESON)));
        lore.add(ItemUtils.formatPropertyName(matLinks, TinkerMaterialManager.getTraitName(matLinks, TraitPartType.LINKS)));
        lore.add(ThemeUtils.getLine());
        lore.add(ItemUtils.getLoreExp(c));
        lore.add(ItemUtils.getLoreModSlots(c));
        lore.add(ThemeUtils.getLine());
        Map<String, Integer> mapAmounts = Modifications.getModificationMapArmour(itemStack);
        Map<String, Integer> mapLevels = Modifications.getAllModLevels(itemStack);
        for (Map.Entry<String, Integer> entry : mapLevels.entrySet()) {
            int level = entry.getValue();
            Mod mod = Modifications.getModificationDefinitionsArmour().get(entry.getKey());
            if (mod.getRequirementMap().containsKey(level + 1)) {
                String amountRequired = String.valueOf(mod.getRequirementMap().get(level + 1));
                lore.add(ThemeUtils.CLICK_INFO + ThemeUtils.toTitleCase(entry.getKey()) + " Level " + entry.getValue() + ThemeUtils.PASSIVE + " - (" + mapAmounts.get(entry.getKey()) + "/" + amountRequired + ")");
                continue;
            }
            lore.add(ThemeUtils.CLICK_INFO + ThemeUtils.toTitleCase(entry.getKey()) + " Level " + entry.getValue() + ThemeUtils.PASSIVE + " - (MAX)");
        }
        if (!mapLevels.isEmpty()) {
            lore.add(ThemeUtils.getLine());
        }
        im.setLore(lore);
        itemStack.setItemMeta(im);
    }

    public static void rebuildTinkerName(@Nonnull ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            ItemUtils.rebuildToolName(itemStack);
        } else if (ItemUtils.isArmour(itemStack)) {
            ItemUtils.rebuildArmourName(itemStack);
        }
    }

    private static void rebuildToolName(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        String matHead = ItemUtils.getToolHeadMaterial(c);
        String matBind = ItemUtils.getToolBindingMaterial(c);
        String matRod = ItemUtils.getToolRodMaterial(c);
        String toolType = ItemUtils.getToolTypeName(c);
        ItemUtils.setName(itemStack, matHead, matBind, matRod, toolType);
    }

    private static void rebuildArmourName(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        String matPlate = ItemUtils.getArmourPlateMaterial(c);
        String matGambeson = ItemUtils.getArmourGambesonMaterial(c);
        String matLinks = ItemUtils.getArmourLinksMaterial(c);
        String armourType = ItemUtils.getArmourTypeName(c);
        ItemUtils.setName(itemStack, matPlate, matGambeson, matLinks, armourType);
    }

    @ParametersAreNonnullByDefault
    private static void setName(ItemStack itemStack, String first, String second, String third, String type) {
        ItemMeta im = itemStack.getItemMeta();
        String name = MessageFormat.format("{0}{1}-{2}{3}-{4}{5} {6}{7}", TinkerMaterialManager.getById(first).getColor(), ThemeUtils.toTitleCase(first), TinkerMaterialManager.getById(second).getColor(), ThemeUtils.toTitleCase(second), TinkerMaterialManager.getById(third).getColor(), ThemeUtils.toTitleCase(third), ChatColor.WHITE, ThemeUtils.toTitleCase(type));
        im.setDisplayName(name);
        itemStack.setItemMeta(im);
    }

    public static boolean isTinkersBroken(@Nonnull ItemStack itemStack) {
        Damageable damageable = (Damageable)itemStack.getItemMeta();
        return damageable.getDamage() == itemStack.getType().getMaxDurability() - 1;
    }

    public static void damageTinkersItem(@Nonnull ItemStack itemStack, int amount) {
        ItemMeta im = itemStack.getItemMeta();
        Damageable damageable = (Damageable)im;
        if (damageable.getDamage() + amount >= itemStack.getType().getMaxDurability()) {
            damageable.setDamage(itemStack.getType().getMaxDurability() - 1);
        } else {
            damageable.setDamage(damageable.getDamage() + amount);
        }
        itemStack.setItemMeta(im);
    }

    public static void repairItem(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        Damageable d = (Damageable)im;
        d.setDamage(0);
        itemStack.setItemMeta(im);
    }

    public static void repairItem(@Nonnull ItemStack itemStack, int amount) {
        ItemMeta im = itemStack.getItemMeta();
        Damageable d = (Damageable)im;
        d.setDamage(Math.max(d.getDamage() - amount, 0));
        itemStack.setItemMeta(im);
    }

    @Nullable
    public static String getToolHeadMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getToolHeadMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getToolHeadMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.TOOL_INFO_HEAD_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getToolBindingMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getToolBindingMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getToolBindingMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.TOOL_INFO_BINDER_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getToolRodMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getToolRodMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getToolRodMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.TOOL_INFO_ROD_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getToolTypeName(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getToolTypeName(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getToolTypeName(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.TOOL_INFO_TOOL_TYPE, PersistentDataType.STRING);
    }

    @Nullable
    public static String getArmourPlateMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getArmourPlateMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getArmourPlateMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.ARMOUR_INFO_PLATE_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getArmourGambesonMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getArmourGambesonMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getArmourGambesonMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.ARMOUR_INFO_GAMBESON_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getArmourLinksMaterial(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getArmourLinksMaterial(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getArmourLinksMaterial(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.ARMOUR_INFO_LINKS_MATERIAL, PersistentDataType.STRING);
    }

    @Nullable
    public static String getArmourTypeName(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.getArmourTypeName(im.getPersistentDataContainer());
    }

    @Nullable
    public static String getArmourTypeName(@Nonnull PersistentDataContainer c) {
        return (String)c.get(Keys.ARMOUR_INFO_ARMOUR_TYPE, PersistentDataType.STRING);
    }

    @Nonnull
    public static String formatMaterialName(String s) {
        return TinkerMaterialManager.getById(s).getColor() + ThemeUtils.toTitleCase(s);
    }

    @Nonnull
    public static String formatPropertyName(String s, String p) {
        return TinkerMaterialManager.getColorById(s) + p;
    }

    public static boolean isMeltable(ItemStack itemStack) {
        return SlimeTinker.getInstance().getCmManager().meltingRecipes.containsKey(StackUtils.getIdOrType(itemStack));
    }

    public static MoltenResult getMoltenResult(ItemStack itemStack) {
        return SlimeTinker.getInstance().getCmManager().meltingRecipes.get(StackUtils.getIdOrType(itemStack));
    }

    public static boolean doesUnequipWhenBroken(ItemStack itemStack) {
        return !ItemUtils.getArmourPlateMaterial(itemStack).equals("DURALIUM");
    }

    public static boolean isTool(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(Keys.TOOL_INFO_TOOL_TYPE, PersistentDataType.STRING);
    }

    public static boolean isArmour(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.getType() != Material.AIR && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(Keys.ARMOUR_INFO_ARMOUR_TYPE, PersistentDataType.STRING);
    }

    public static boolean isTinkers(@Nullable ItemStack itemStack) {
        return ItemUtils.isTool(itemStack) || ItemUtils.isArmour(itemStack);
    }

    public static boolean doesNotWorkWhenBroken(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return !ItemUtils.getToolHeadMaterial(itemStack).equals("DURALIUM") && !ItemUtils.getToolRodMaterial(itemStack).equals("TITANIUM");
        }
        return true;
    }

    public static boolean repairBenchEasyFix(ItemStack itemStack) {
        return ItemUtils.repairBenchEasyFix1(itemStack) || ItemUtils.repairBenchEasyFix2(itemStack);
    }

    public static boolean repairBenchEasyFix1(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("DURALIUM");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("ALUMINUM");
        }
        return false;
    }

    public static boolean repairBenchEasyFix2(ItemStack itemStack) {
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("ALUMINUM_SINGULARITY");
        }
        return false;
    }

    public static boolean repairBenchCraftsman(ItemStack itemStack) {
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("SMITHIUM");
        }
        return false;
    }

    public static boolean isEnchanting(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolHeadMaterial(itemStack).equals("SILVER") || ItemUtils.getToolHeadMaterial(itemStack).equals("SILVER_SINGULARITY");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("SILVER") || ItemUtils.getArmourLinksMaterial(itemStack).equals("SILVER_SINGULARITY");
        }
        return false;
    }

    public static boolean isEnchanting1(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolHeadMaterial(itemStack).equals("SILVER");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("SILVER");
        }
        return false;
    }

    public static boolean isEnchanting2(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolHeadMaterial(itemStack).equals("SILVER_SINGULARITY");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("SILVER_SINGULARITY");
        }
        return false;
    }

    public static boolean isConductive(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("COPPER") || ItemUtils.getToolRodMaterial(itemStack).equals("COPPER_SINGULARITY");
        }
        return false;
    }

    public static boolean isConductive1(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("COPPER");
        }
        return false;
    }

    public static boolean isConductive2(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("COPPER_SINGULARITY");
        }
        return false;
    }

    public static boolean cannotDrop(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("SOLDER") || ItemUtils.getToolRodMaterial(itemStack).equals("UNPATENTABLIUM");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourLinksMaterial(itemStack).equals("SOLDER");
        }
        return false;
    }

    public static boolean isReinforced(ItemStack itemStack) {
        if (ItemUtils.isTool(itemStack)) {
            return ItemUtils.getToolRodMaterial(itemStack).equals("REINFORCED_ALLOY");
        }
        if (ItemUtils.isArmour(itemStack)) {
            return ItemUtils.getArmourPlateMaterial(itemStack).equals("REINFORCED_ALLOY");
        }
        return false;
    }

    public static boolean isExperienced(ItemStack itemStack) {
        return ItemUtils.getArmourPlateMaterial(itemStack).equals("REINFORCED_ALLOY");
    }

    public static int getTinkerExp(@Nonnull PersistentDataContainer c) {
        Integer i = (Integer)c.get(Keys.ST_EXP_CURRENT, PersistentDataType.INTEGER);
        return i != null ? i : 0;
    }

    public static int getTinkerExp(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemMeta im = itemStack.getItemMeta();
        PersistentDataContainer c = im.getPersistentDataContainer();
        return ItemUtils.getTinkerExp(c);
    }

    public static int getTinkerRequiredExp(@Nonnull PersistentDataContainer c) {
        return ((Double)c.get(Keys.ST_EXP_REQUIRED, PersistentDataType.DOUBLE)).intValue();
    }

    public static int getTinkerRequiredExp(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemMeta im = itemStack.getItemMeta();
        PersistentDataContainer c = im.getPersistentDataContainer();
        return ItemUtils.getTinkerRequiredExp(c);
    }

    public static int getTinkerLevel(@Nonnull PersistentDataContainer c) {
        Integer i = (Integer)c.get(Keys.ST_LEVEL, PersistentDataType.INTEGER);
        return i != null ? i : 0;
    }

    public static int getTinkerLevel(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemMeta im = itemStack.getItemMeta();
        PersistentDataContainer c = im.getPersistentDataContainer();
        return ItemUtils.getTinkerLevel(c);
    }

    public static int getTinkerModifierSlots(@Nonnull PersistentDataContainer c) {
        Integer i = (Integer)c.get(Keys.ST_MOD_SLOTS, PersistentDataType.INTEGER);
        return i != null ? i : 0;
    }

    public static int getTinkerModifierSlots(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        ItemMeta im = itemStack.getItemMeta();
        PersistentDataContainer c = im.getPersistentDataContainer();
        return ItemUtils.getTinkerModifierSlots(c);
    }

    public static void setTinkerModifierSlots(@Nonnull PersistentDataContainer c, int amount) {
        c.set(Keys.ST_MOD_SLOTS, PersistentDataType.INTEGER, (Object)amount);
    }

    @Nonnull
    public static String getLoreExp(PersistentDataContainer c) {
        return ThemeUtils.ITEM_TOOL + "Level: " + ChatColor.WHITE + ItemUtils.getTinkerLevel(c) + ThemeUtils.PASSIVE + " (" + ItemUtils.getTinkerExp(c) + " / " + ItemUtils.getTinkerRequiredExp(c) + ")";
    }

    @Nonnull
    public static String getLoreModSlots(PersistentDataContainer c) {
        return ThemeUtils.ITEM_TOOL + "Modifier Slots: " + ChatColor.WHITE + ItemUtils.getTinkerModifierSlots(c);
    }

    public static boolean rejectCraftingRecipe(@Nonnull SlimefunItemStack i) {
        return ItemUtils.rejectCraftingRecipe(i.getItemId());
    }

    public static boolean rejectCraftingRecipe(@Nonnull SlimefunItem i) {
        return ItemUtils.rejectCraftingRecipe(i.getId());
    }

    public static boolean rejectCraftingRecipe(String s) {
        return ItemUtils.isBackpack(s);
    }

    public static boolean isBackpack(@Nonnull String s) {
        return s.matches("(.*)BACKPACK(.*)");
    }

    public static void incrementRandomEnchant(ItemStack i, ItemMeta im) {
        Enchantment randEnchant = Enchantment.values()[GeneralUtils.roll(Enchantment.values().length, false)];
        if (im.hasEnchant(randEnchant)) {
            im.addEnchant(randEnchant, i.getEnchantmentLevel(randEnchant) + 1, true);
        } else {
            im.addEnchant(randEnchant, 1, true);
        }
    }

    public static boolean onCooldown(@Nonnull ItemStack i, String name) {
        ItemMeta im = i.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)SlimeTinker.getInstance(), "cooldown_" + name);
        long time = System.currentTimeMillis();
        long cd = PersistentDataAPI.getLong((PersistentDataHolder)im, (NamespacedKey)key, (long)0L);
        return cd > time;
    }

    public static void setCooldown(@Nonnull ItemStack i, String name, long duration) {
        ItemMeta im = i.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)SlimeTinker.getInstance(), "cooldown_" + name);
        long time = System.currentTimeMillis();
        long cd = time + duration;
        PersistentDataAPI.setLong((PersistentDataHolder)im, (NamespacedKey)key, (long)cd);
        i.setItemMeta(im);
    }

    public static boolean isToolExplosive(@Nonnull ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        return ItemUtils.isToolExplosive(im.getPersistentDataContainer());
    }

    public static boolean isToolExplosive(@Nonnull PersistentDataContainer c) {
        NamespacedKey sfIDKey = new NamespacedKey((Plugin)Slimefun.instance(), "slimefun_item");
        String sID = (String)c.get(sfIDKey, PersistentDataType.STRING);
        return sID.contains("_EXP");
    }

    public static boolean isToolExplosive(@Nonnull String headMaterial, String rodMaterial) {
        return headMaterial.equals("REINFORCED_ALLOY") || rodMaterial.equals("HARDENED_METAL") || headMaterial.equals("INFINITY_SINGULARITY") || headMaterial.equals("OSMIUM");
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id) {
        return ItemUtils.getItemByID(id, 1);
    }

    @Nullable
    public static ItemStack getItemByID(@Nonnull String id, int amount) {
        SlimefunItem sfItem = SlimefunItem.getById((String)id);
        if (sfItem != null) {
            return new CustomItemStack(sfItem.getItem(), amount);
        }
        return null;
    }

    @Nonnull
    public static ItemStack[] getMiddleOnlyRecipe(@Nonnull ItemStack item) {
        return new ItemStack[]{null, null, null, null, item, null, null, null, null};
    }
}

