/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import io.github.sefiraat.slimetinker.items.Guide;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public final class Experience {
    public static final double EXP_LEVEL_BASE = 100.0;
    public static final double EXP_GROWTH = 1.3;

    private Experience() {
        throw new IllegalStateException("Utility class");
    }

    public static void setupExpNew(ItemMeta im) {
        PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)Keys.ST_EXP_CURRENT, (int)0);
        PersistentDataAPI.setDouble((PersistentDataHolder)im, (NamespacedKey)Keys.ST_EXP_REQUIRED, (double)100.0);
        PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)Keys.ST_LEVEL, (int)0);
        PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)Keys.ST_MOD_SLOTS, (int)0);
    }

    public static void addExp(ItemStack itemStack, int amount, Player player, boolean tool) {
        int eLevel;
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        if (Experience.copperChecks(itemStack, player, amount)) {
            return;
        }
        int currentExp = (Integer)c.get(Keys.ST_EXP_CURRENT, PersistentDataType.INTEGER);
        double expRequired = (Double)c.get(Keys.ST_EXP_REQUIRED, PersistentDataType.DOUBLE);
        int level = (Integer)c.get(Keys.ST_LEVEL, PersistentDataType.INTEGER);
        int modSlots = (Integer)c.get(Keys.ST_MOD_SLOTS, PersistentDataType.INTEGER);
        int newExp = 0;
        Map<String, Integer> modLevels = Modifications.getAllModLevels(itemStack);
        if (modLevels.containsKey(Material.EMERALD.toString()) && (eLevel = modLevels.get(Material.EMERALD.toString()).intValue()) > 0) {
            int n = amount = tool ? amount + eLevel : (int)Math.ceil((double)amount * (1.0 + (double)eLevel * 0.1));
        }
        if ((double)(currentExp + amount) >= expRequired) {
            ++modSlots;
            expRequired *= 1.3;
            Experience.promoteMaterial(itemStack, ++level, player);
            player.sendMessage(ThemeUtils.SUCCESS + "Your Tinker's tool has leveled up! +1 Modifier Slot");
            Experience.silverChecks(itemStack, im, player);
        } else {
            newExp = currentExp + amount;
        }
        c.set(Keys.ST_EXP_CURRENT, PersistentDataType.INTEGER, (Object)newExp);
        c.set(Keys.ST_EXP_REQUIRED, PersistentDataType.DOUBLE, (Object)expRequired);
        c.set(Keys.ST_LEVEL, PersistentDataType.INTEGER, (Object)level);
        c.set(Keys.ST_MOD_SLOTS, PersistentDataType.INTEGER, (Object)modSlots);
        itemStack.setItemMeta(im);
        ItemUtils.rebuildTinkerLore(itemStack);
    }

    private static void promoteMaterial(ItemStack itemStack, int level, Player player) {
        String type;
        if (level > 11) {
            return;
        }
        ItemMeta im = itemStack.getItemMeta();
        if (ItemUtils.isTool(itemStack)) {
            type = PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_TOOL_TYPE);
        } else if (ItemUtils.isArmour(itemStack)) {
            type = PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_ARMOUR_TYPE);
        } else {
            throw new IllegalArgumentException("Trying to promote something that isn't armour or a tool!");
        }
        if (Guide.getGrowthMap().get(type).containsKey(level)) {
            itemStack.setType(Guide.getGrowthMap().get(type).get(level));
            ItemUtils.repairItem(itemStack);
            player.sendMessage(ThemeUtils.SUCCESS + "Your tool has been promoted!");
        }
    }

    private static boolean copperChecks(ItemStack itemStack, Player player, int amount) {
        if (ItemUtils.isConductive1(itemStack)) {
            player.giveExp(amount);
            return true;
        }
        if (ItemUtils.isConductive2(itemStack)) {
            player.giveExp((int)Math.ceil((double)amount * 1.5));
            return true;
        }
        return false;
    }

    private static void silverChecks(ItemStack itemStack, ItemMeta im, Player player) {
        if (ItemUtils.isEnchanting(itemStack)) {
            int number = ItemUtils.isEnchanting2(itemStack) ? 3 : 1;
            int amount = ThreadLocalRandom.current().nextInt(1, number + 1);
            for (int i = 0; i < amount; ++i) {
                ItemUtils.incrementRandomEnchant(itemStack, im);
            }
            player.sendMessage(ThemeUtils.SUCCESS + "It also gained [" + amount + "] random enchantment(s)! Hope it's good :>");
        }
    }
}

