/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.runnables;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.TickEvents;
import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class EffectTick
extends BukkitRunnable {
    public void run() {
        for (Player player : SlimeTinker.getInstance().getServer().getOnlinePlayers()) {
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            HashMap<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
            EventFriend friend = new EventFriend(player, TraitEventType.TICK);
            EventChannels.checkTool(friend);
            EventChannels.checkArmour(friend);
            this.checkModifications(heldItem, potionEffects);
            if (!friend.isCancelEvent()) {
                EventChannels.settlePotionEffects(friend);
            }
            for (Map.Entry entry : potionEffects.entrySet()) {
                player.addPotionEffect(new PotionEffect((PotionEffectType)entry.getKey(), 60, ((Integer)entry.getValue()).intValue(), false, true, true));
            }
            TickEvents.magnetic(friend);
        }
    }

    private void checkModifications(ItemStack heldItem, Map<PotionEffectType, Integer> potionEffects) {
        if (!ItemUtils.isTool(heldItem)) {
            return;
        }
        Map<String, Integer> modLevels = Modifications.getAllModLevels(heldItem);
        for (Map.Entry<String, Integer> entry : modLevels.entrySet()) {
            if (!Material.REDSTONE.toString().equals(entry.getKey())) continue;
            this.modRedstone(entry.getValue(), potionEffects);
        }
    }

    private void modRedstone(int level, @Nonnull Map<PotionEffectType, Integer> potionEffects) {
        if (potionEffects.containsKey(PotionEffectType.FAST_DIGGING)) {
            potionEffects.put(PotionEffectType.FAST_DIGGING, potionEffects.get(PotionEffectType.FAST_DIGGING) + level);
        } else {
            potionEffects.put(PotionEffectType.FAST_DIGGING, level);
        }
    }
}

