/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.listeners;

import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.listeners.BlockMap;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.BlockUtils;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class BlockBreakListener
implements Listener {
    public static final Map<Location, EventFriend> EVENT_FRIEND_MAP = new HashMap<Location, EventFriend>();

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        if (Slimefun.getIntegrations().isEventFaked((Event)event) || Slimefun.getIntegrations().isCustomBlock(event.getBlock()) || event.isCancelled() || this.isLockedTool(player, heldItem) || !BlockUtils.isValidBreakEvent(block, player)) {
            return;
        }
        EventFriend friend = new EventFriend(player, TraitEventType.BLOCK_BREAK);
        friend.setBlock(block);
        friend.setDrops(block.getDrops(heldItem));
        friend.setAddDrops(new ArrayList<ItemStack>());
        friend.setRemoveDrops(new ArrayList<ItemStack>());
        EventChannels.checkTool(friend);
        EventChannels.checkArmour(friend);
        if (friend.isActionTaken()) {
            if (friend.isCancelEvent()) {
                event.setCancelled(true);
                return;
            }
            this.modChecks(heldItem, block, friend.getAddDrops());
            EventChannels.settlePotionEffects(friend);
            if (ItemUtils.isTool(heldItem)) {
                if (this.shouldGrantExp(heldItem, event.getBlock())) {
                    Experience.addExp(heldItem, (int)Math.ceil(1.0 * friend.getToolExpMod()), event.getPlayer(), true);
                }
                if (event.getExpToDrop() > 0 && friend.isMetalCheck()) {
                    Experience.addExp(heldItem, (int)Math.ceil((double)event.getExpToDrop() / 10.0), event.getPlayer(), true);
                    event.setExpToDrop(0);
                }
            }
            EVENT_FRIEND_MAP.put(block.getLocation(), friend);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDrops(BlockDropItemEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        EventFriend friend = EVENT_FRIEND_MAP.remove(location);
        if (friend != null) {
            HashMap remainingItems;
            event.getItems().clear();
            Player player = friend.getPlayer();
            for (ItemStack i : friend.getDrops()) {
                if (friend.getRemoveDrops().contains(i) || i.getType() == Material.AIR) continue;
                if (friend.isBlocksIntoInv()) {
                    remainingItems = player.getInventory().addItem(new ItemStack[]{i});
                    for (ItemStack i2 : remainingItems.values()) {
                        block.getWorld().dropItem(block.getLocation().clone().add(0.5, 0.5, 0.5), i2);
                    }
                    continue;
                }
                block.getWorld().dropItem(block.getLocation().clone().add(0.5, 0.5, 0.5), i);
            }
            for (ItemStack i : friend.getAddDrops()) {
                if (friend.isBlocksIntoInv()) {
                    remainingItems = player.getInventory().addItem(new ItemStack[]{i});
                    for (ItemStack i2 : remainingItems.values()) {
                        block.getWorld().dropItem(block.getLocation().clone().add(0.5, 0.5, 0.5), i2);
                    }
                    continue;
                }
                block.getWorld().dropItem(block.getLocation().clone().add(0.5, 0.5, 0.5), i);
            }
        }
    }

    private boolean shouldGrantExp(ItemStack itemStack, Block block) {
        ItemMeta im = itemStack.getItemMeta();
        assert (im != null);
        PersistentDataContainer c = im.getPersistentDataContainer();
        String toolType = (String)c.get(Keys.TOOL_INFO_TOOL_TYPE, PersistentDataType.STRING);
        assert (toolType != null);
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            if (ageable.getAge() == ageable.getMaximumAge()) {
                return toolType.equals("HOE");
            }
            return false;
        }
        if (!BlockMap.getMaterialMap().containsKey(block.getType())) {
            return false;
        }
        return BlockMap.getMaterialMap().get(block.getType()).equals(toolType);
    }

    private void modChecks(ItemStack heldItem, Block block, Collection<ItemStack> addDrops) {
        this.modCheckLapis(heldItem, block, addDrops);
    }

    private void modCheckLapis(ItemStack heldItem, Block block, Collection<ItemStack> addDrops) {
        Map<String, Integer> modLevels = Modifications.getAllModLevels(heldItem);
        if (block.getDrops().isEmpty() || !modLevels.containsKey(Material.LAPIS_LAZULI.toString()) || heldItem.containsEnchantment(Enchantment.SILK_TOUCH)) {
            return;
        }
        int lapisLevel = modLevels.get(Material.LAPIS_LAZULI.toString());
        ItemStack dummyFortune = new ItemStack(Material.DIAMOND_PICKAXE);
        dummyFortune.addEnchantment(Enchantment.LOOT_BONUS_BLOCKS, 3);
        ArrayList<Material> materialList = new ArrayList<Material>();
        for (ItemStack drop : block.getDrops()) {
            for (ItemStack dropFort : block.getDrops(dummyFortune)) {
                if (dropFort.getType() != drop.getType() || dropFort.getAmount() <= drop.getAmount()) continue;
                materialList.add(drop.getType());
            }
        }
        for (ItemStack drop : block.getDrops(heldItem)) {
            int additionalAmount;
            if (!materialList.contains(drop.getType()) || (additionalAmount = (int)Math.floor((double)drop.getAmount() * ((double)lapisLevel * 0.1))) <= 0) continue;
            ItemStack additionalDrop = new ItemStack(drop.getType());
            additionalDrop.setAmount(additionalAmount);
            addDrops.add(additionalDrop);
            Location location = block.getLocation().clone().add(0.5, 0.5, 0.5);
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.BLUE, 2.0f);
            block.getWorld().spawnParticle(Particle.REDSTONE, location, 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
        }
    }

    public boolean isLockedTool(Player player, ItemStack itemStack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        return slimefunItem != null && !slimefunItem.canUse(player, false);
    }
}

