/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.smeltery;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.infinitylib.common.StackUtils;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterial;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterialManager;
import io.github.sefiraat.slimetinker.items.tinkermaterials.elements.Alloy;
import io.github.sefiraat.slimetinker.items.tinkermaterials.recipes.CastResult;
import io.github.sefiraat.slimetinker.items.tinkermaterials.recipes.MoltenResult;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.AbstractCache;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.TinkersSmeltery;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class TinkersSmelteryCache
extends AbstractCache {
    public static final int LAVA_MAX = 1000;
    public static final int LAVA_PER_BUCKET = 250;
    public static final int METALS_MAX = 1000;
    public static final String LAVA_LEVEL_BS = "tnk-lava-level";
    public static final String METAL_LEVEL_PREFIX = "tnk-metal:";
    private final Map<String, Integer> tankContent = new LinkedHashMap<String, Integer>();
    private int levelLava;

    public TinkersSmelteryCache(BlockMenu blockMenu) {
        super(blockMenu);
        this.process(true);
        blockMenu.addItem(32, (ItemStack)GUIItems.MENU_PURGE);
        blockMenu.addMenuClickHandler(32, (player, i, itemStack, clickAction) -> {
            this.clickPurge(clickAction);
            return false;
        });
        blockMenu.addItem(33, (ItemStack)GUIItems.MENU_ALLOY);
        blockMenu.addMenuClickHandler(33, (player, i, itemStack, clickAction) -> {
            this.clickAlloy();
            return false;
        });
        blockMenu.addItem(34, (ItemStack)GUIItems.MENU_POUR);
        blockMenu.addMenuClickHandler(34, (player, i, itemStack, clickAction) -> {
            this.clickPour(player);
            return false;
        });
    }

    public void input() {
        ItemStack input = this.blockMenu.getItemInSlot(10);
        if (input == null) {
            return;
        }
        if (input.getType() == Material.LAVA_BUCKET) {
            if (this.levelLava <= 750 && this.blockMenu.fits(new ItemStack(Material.BUCKET), new int[]{16})) {
                input.setAmount(input.getAmount() - 1);
                this.blockMenu.pushItem(new ItemStack(Material.BUCKET), new int[]{16});
                this.levelLava += 250;
            } else if (this.blockMenu.fits(new ItemStack(Material.LAVA_BUCKET), new int[]{16})) {
                input.setAmount(input.getAmount() - 1);
                this.blockMenu.pushItem(new ItemStack(Material.LAVA_BUCKET), new int[]{16});
            }
            return;
        }
        MoltenResult result = ItemUtils.getMoltenResult(input);
        if (result == null || !this.canMelt(input, result)) {
            return;
        }
        if (this.canFit(result.getAmount())) {
            this.addMetal(result);
            input.setAmount(input.getAmount() - 1);
            this.levelLava -= result.getAmount();
        }
    }

    private boolean canMelt(ItemStack itemStack, MoltenResult result) {
        return ItemUtils.isMeltable(itemStack) && this.levelLava >= result.getAmount();
    }

    private boolean canFit(int incoming) {
        return this.getMetalLevel() + incoming <= 1000;
    }

    private Integer getMetalLevel() {
        return this.tankContent.values().stream().mapToInt(Integer::valueOf).sum();
    }

    public void process(boolean first) {
        this.input();
        this.updateView();
        if (!first) {
            this.syncBlock();
        }
    }

    public void kill(Location location) {
        this.drops(location);
        BlockStorage.clearBlockInfo((Location)location);
    }

    public void drops(Location location) {
        this.blockMenu.dropItems(location, new int[]{10});
        this.blockMenu.dropItems(location, new int[]{16});
        this.blockMenu.dropItems(location, new int[]{13});
        this.blockMenu.dropItems(location, TinkersSmeltery.CAST_STORE_SLOTS);
    }

    public void updateView() {
        if (this.blockMenu.hasViewer()) {
            int metalLevel = this.getMetalLevel();
            int lavaPercent = (int)Math.ceil((float)this.levelLava * 100.0f / 1000.0f);
            int metalPercent = (int)Math.ceil((float)metalLevel * 100.0f / 1000.0f);
            this.blockMenu.replaceExistingItem(28, (ItemStack)GUIItems.menuLavaInfo(lavaPercent, this.levelLava, 1000));
            this.blockMenu.addMenuClickHandler(28, (player, i, itemStack, clickAction) -> false);
            this.blockMenu.replaceExistingItem(30, (ItemStack)GUIItems.menuMetalInfo(metalPercent, metalLevel, 1000, this.tankContent));
            this.blockMenu.addMenuClickHandler(30, (player, i, itemStack, clickAction) -> {
                this.clickMetalTank();
                return false;
            });
        }
    }

    private void syncBlock() {
        BlockStorage.addBlockInfo((Block)this.blockMenu.getBlock(), (String)LAVA_LEVEL_BS, (String)String.valueOf(this.levelLava));
        for (Map.Entry<String, Integer> e : this.tankContent.entrySet()) {
            BlockStorage.addBlockInfo((Block)this.blockMenu.getBlock(), (String)(METAL_LEVEL_PREFIX + e.getKey()), (String)String.valueOf(e.getValue()));
        }
    }

    private void addMetal(MoltenResult result) {
        if (this.tankContent.containsKey(result.getComponentMaterial().getId())) {
            this.tankContent.put(result.getComponentMaterial().getId(), this.tankContent.get(result.getComponentMaterial().getId()) + result.getAmount());
        } else {
            this.tankContent.put(result.getComponentMaterial().getId(), result.getAmount());
        }
    }

    private void addMetal(String metalName, int amount) {
        if (this.tankContent.containsKey(metalName)) {
            this.tankContent.put(metalName, this.tankContent.get(metalName) + amount);
        } else {
            this.tankContent.put(metalName, amount);
        }
    }

    private void removeMetal(String metalId, int amount) {
        int volume = this.tankContent.get(metalId);
        if (volume - amount <= 0) {
            this.tankContent.remove(metalId);
            BlockStorage.addBlockInfo((Location)this.blockMenu.getLocation(), (String)(METAL_LEVEL_PREFIX + metalId), null);
        } else {
            this.tankContent.put(metalId, this.tankContent.get(metalId) - amount);
        }
    }

    private void clickPurge(ClickAction clickAction) {
        if (this.tankContent.isEmpty()) {
            return;
        }
        if (clickAction.isRightClicked()) {
            this.tankContent.clear();
            Config c = BlockStorage.getLocationInfo((Location)this.blockMenu.getLocation());
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : c.getKeys()) {
                if (!key.startsWith(METAL_LEVEL_PREFIX)) continue;
                keys.add(key);
            }
            for (String key : keys) {
                BlockStorage.addBlockInfo((Location)this.blockMenu.getLocation(), (String)key, null);
            }
            return;
        }
        Optional first = this.tankContent.keySet().stream().findFirst();
        if (first.isPresent()) {
            String key = (String)first.get();
            this.tankContent.remove(key);
            BlockStorage.addBlockInfo((Location)this.blockMenu.getLocation(), (String)(METAL_LEVEL_PREFIX + key), null);
        }
    }

    private void clickAlloy() {
        for (Alloy alloy : TinkerMaterialManager.getAlloys()) {
            if (!alloy.getAlloyMap().keySet().equals(this.tankContent.keySet())) continue;
            int maxPossible = 0;
            for (Map.Entry<String, Integer> entry : alloy.getAlloyMap().entrySet()) {
                int requiredAmount;
                int tankAmount = this.tankContent.get(entry.getKey());
                if (tankAmount < (requiredAmount = entry.getValue().intValue())) {
                    return;
                }
                int possible = Math.floorDiv(tankAmount, requiredAmount);
                if (maxPossible != 0 && maxPossible <= possible) continue;
                maxPossible = possible;
            }
            for (Map.Entry<String, Integer> entry : alloy.getAlloyMap().entrySet()) {
                this.removeMetal(entry.getKey(), entry.getValue() * maxPossible);
            }
            this.addMetal(alloy.getParent().getId(), maxPossible);
        }
    }

    private void clickPour(Player player) {
        ItemStack inputItem = this.blockMenu.getItemInSlot(13);
        if (inputItem == null || !SlimeTinker.getInstance().getCmManager().castingRecipes.containsKey(StackUtils.getIdOrType(inputItem))) {
            player.sendMessage(ThemeUtils.WARNING + "Please input a valid cast before trying to pour metals.");
            return;
        }
        Optional first = this.tankContent.keySet().stream().findFirst();
        if (!first.isPresent()) {
            player.sendMessage(ThemeUtils.WARNING + "There isn't any metal to pour.");
            return;
        }
        String metalID = (String)first.get();
        TinkerMaterial tinkerMaterial = TinkerMaterialManager.getById(metalID);
        CastResult result = SlimeTinker.getInstance().getCmManager().castingRecipes.get(StackUtils.getIdOrType(inputItem));
        if (!result.getOutputs().containsKey(tinkerMaterial)) {
            player.sendMessage(ThemeUtils.WARNING + "The selected metal cannot be shaped into the selected cast.");
            return;
        }
        ItemStack outputItem = result.getOutputs().get(tinkerMaterial).clone();
        int metalAmount = result.getAmount();
        if (this.tankContent.get(metalID) < metalAmount) {
            player.sendMessage(ThemeUtils.WARNING + "You do not have enough metal to fill this cast");
            return;
        }
        if (!this.blockMenu.fits(outputItem, new int[]{16})) {
            player.sendMessage(ThemeUtils.WARNING + "Please clear your casting table first");
            return;
        }
        this.removeMetal(metalID, result.getAmount());
        this.blockMenu.pushItem(outputItem, new int[]{16});
        if (result.isInputBurns()) {
            inputItem.setAmount(inputItem.getAmount() - 1);
        }
    }

    private void clickMetalTank() {
        Optional first = this.tankContent.keySet().stream().findFirst();
        if (first.isPresent() && this.tankContent.size() > 1) {
            String string = (String)first.get();
            int amount = this.tankContent.get(string);
            this.tankContent.remove(string);
            this.tankContent.put(string, amount);
        }
    }

    public Map<String, Integer> getTankContent() {
        return this.tankContent;
    }

    public int getLevelLava() {
        return this.levelLava;
    }

    public void setLevelLava(int levelLava) {
        this.levelLava = levelLava;
    }
}

