/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.tinkermaterials.elements;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.infinitylib.common.StackUtils;
import io.github.sefiraat.slimetinker.itemgroups.ItemGroups;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterial;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.DummySmelteryTrait;
import io.github.sefiraat.slimetinker.managers.SupportedPluginsManager;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.sefiraat.slimetinker.utils.enums.ThemeItemType;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

public class MaterialTrait {
    private String traitName;
    private String[] lore;
    private String addedBy;
    private String sponsor = null;
    private SlimefunItemStack partType;
    private final Map<TraitEventType, Consumer<EventFriend>> eventTypeConsumerMap = new EnumMap<TraitEventType, Consumer<EventFriend>>(TraitEventType.class);
    private SlimefunItemStack itemStack;
    private SlimefunItem item;
    public static final SlimefunItemStack PROP_HEAD = ThemeUtils.themedItemStack("PROP_HEAD", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTBkZmM4YTM1NjNiZjk5NmY1YzFiNzRiMGIwMTViMmNjZWIyZDA0Zjk0YmJjZGFmYjIyOTlkOGE1OTc5ZmFjMSJ9fX0=", ThemeItemType.PART, "Part: Head", ThemeUtils.PASSIVE + "Any 'Head' item (Sword Blade, Axe Head etc.)");
    public static final SlimefunItemStack PROP_BINDING = ThemeUtils.themedItemStack("PROP_BINDING", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTg3M2MyZWVlN2EyY2M1NGQ2OWI3MzY1MDUzZWUxMGRjYjc4YmIwMDA0MGJhNTZmOTZiYWU1ZWUyZDdkMzJhOCJ9fX0=", ThemeItemType.PART, "Part: Binder", ThemeUtils.PASSIVE + "Any 'Binder' item.");
    public static final SlimefunItemStack PROP_ROD = ThemeUtils.themedItemStack("PROP_ROD", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODNmYTMwYTE5YmE5ODk3OWNlMGM3NjRhN2JiMGNmMTg0NzFjN2YyODU1ZDQ0MzQzNTk3NmU5NzJjNTFiODQ2ZiJ9fX0=", ThemeItemType.PART, "Part: Tool Rod", ThemeUtils.PASSIVE + "Any 'Tool Rod' item.");
    public static final SlimefunItemStack PROP_PLATES = ThemeUtils.themedItemStack("PROP_PLATES", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWU3ZTUxNTdmODA1Y2VjMDk5NjljYzM1MTAxNzlkMzk4NzQwMmM1NGQxOGMxMjQ2YmIxNGRiM2FkNTBlZjQxYiJ9fX0=", ThemeItemType.PART, "Part: Plates", ThemeUtils.PASSIVE + "Any 'Plate' item (Helm Plates, Boot Plates etc.)");
    public static final SlimefunItemStack PROP_GAMBESON = ThemeUtils.themedItemStack("PROP_GAMBESON", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWNiNzdhOWNlYmUxYzE5NjIxMDUyN2EwNjk4OTNiOGY2Mzk1NGIzNDc1NzIwZjgwNDBmZTEyMzNhYWY4OWYwZiJ9fX0=", ThemeItemType.PART, "Part: Gambeson", ThemeUtils.PASSIVE + "Any 'Gambeson' item.");
    public static final SlimefunItemStack PROP_LINKS = ThemeUtils.themedItemStack("PROP_LINKS", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjMxNDAwZjM1YmFlMGNiMmJkZDAzMTRhNDI0ZjEzMDdiNjkyMGJkZmE2ODE0MjczNjUzMGY0OTA0NjNhNTEzYSJ9fX0=", ThemeItemType.PART, "Part: Mail Links", ThemeUtils.PASSIVE + "Any 'Mail Link' item.");

    @Nonnull
    public String getTraitName() {
        return this.traitName;
    }

    @Nonnull
    public MaterialTrait setTraitName(@Nonnull String traitName) {
        this.traitName = traitName;
        return this;
    }

    @Nonnull
    public String[] getLore() {
        return this.lore;
    }

    @Nonnull
    public MaterialTrait setLore(String ... lore) {
        this.lore = lore;
        return this;
    }

    @Nonnull
    public String getAddedBy() {
        return this.addedBy;
    }

    @Nonnull
    public MaterialTrait setAddedBy(@Nonnull String addedBy) {
        this.addedBy = addedBy;
        return this;
    }

    @Nullable
    public String getSponsoredBy() {
        return this.sponsor;
    }

    @Nonnull
    public MaterialTrait setSponsoredBy(@Nonnull String sponsor) {
        this.sponsor = sponsor;
        return this;
    }

    @Nonnull
    public SlimefunItemStack getPartType() {
        return this.partType;
    }

    @Nonnull
    public MaterialTrait setPartType(@Nonnull SlimefunItemStack partType) {
        this.partType = partType;
        return this;
    }

    @Nonnull
    public MaterialTrait addConsumer(@Nonnull TraitEventType type, @Nonnull Consumer<EventFriend> consumer) {
        this.eventTypeConsumerMap.put(type, consumer);
        return this;
    }

    public SlimefunItemStack getItemStack() {
        return this.itemStack;
    }

    public SlimefunItem getItem() {
        return this.item;
    }

    public void run(@Nonnull TraitEventType type, @Nonnull EventFriend friend) {
        Consumer<EventFriend> consumer = this.eventTypeConsumerMap.get((Object)type);
        if (consumer != null) {
            consumer.accept(friend);
        }
    }

    public void setupTrait(@Nonnull TinkerMaterial parentCM) {
        ArrayList<String> newLore = new ArrayList<String>(Arrays.asList(this.lore));
        newLore.add("");
        newLore.add(ThemeUtils.ITEM_TYPEDESC + "Added by: " + this.addedBy);
        if (this.sponsor != null) {
            newLore.add("");
            newLore.add(ThemeUtils.ITEM_TYPEDESC + "Sponsored by: " + this.sponsor);
        }
        this.itemStack = ThemeUtils.themedItemStack(MessageFormat.format("{0}_TRAIT_{1}_{2}", this.traitName.toUpperCase(Locale.ROOT).replace(" ", "_"), this.partType.getItemId().toUpperCase(Locale.ROOT), StackUtils.getIdOrType(parentCM.getRepresentativeStack())), MaterialTrait.getTraitTexture(this.addedBy), ThemeItemType.PROP, "Trait : " + this.traitName, newLore);
        this.item = new SlimefunItem((ItemGroup)ItemGroups.TRAITS, this.itemStack, DummySmelteryTrait.TYPE, MaterialTrait.propRecipe(this.partType, parentCM.getRepresentativeStack()));
        this.item.register((SlimefunAddon)SlimeTinker.getInstance());
    }

    @Nonnull
    protected static String getTraitTexture(@Nonnull String addedBy) {
        if (addedBy.equals(SupportedPluginsManager.CORE_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzY1Y2IxODVjNjQxY2JlNzRlNzBiY2U2ZTZhMWVkOTBhMTgwZWMxYTQyMDM0ZDVjNGFlZDU3YWY1NjBmYzgzYSJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.INFINITY_EXPANSION_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2NjNGNjMmVhYTVmNzRlMjZjYjA0ZWM0YTQxZWRlYWU0ZDA0YWY5ZTJmM2U5OWJhNjRkNmM5YzBjNWUzYTdiZiJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.SLIMEFUN_WARFARE_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzlmZmRkOWYwN2M3ZWFjMTdhMGIwNWJjNzk2YmE0ZmNlMTk0MWM3MDVmMWE3ZmM4YjQ2YzI4ODI3MTIzZGU1MiJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.DYNATECH_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTMwZjgxYjhjN2E3ZDA5NGUwMTcyYjE4ZTIwOWE1NGMzNjI4N2JmMjIzZWRmYWVjZDg1YTE2MjY1MjUyZDVlNSJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.LITEXPANSION_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWZkYzZkM2JhZDM5NmU3YWJjNTdlZjU2ZTg0ZTAxNmQwMTZiODYyNzQ3YjlmNTliMDU1YWMyMGU0ZTNhMDkzMCJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.TRANSCENDENCE_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmVlMTc0ZjQxZTU5NGU2NGVhMzE0MWMwN2RhZjdhY2YxZmEwNDVjMjMwYjJiMGIwZmIzZGExNjNkYjIyZjQ1NSJ9fX0=";
        }
        if (addedBy.equals(SupportedPluginsManager.NETWORKS_NOTE)) {
            return "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTlmNGFhY2ZjNjI3ZWU2NGEzMjU3YWQ1Mjc4MzU1NWYyYjM1OGNiN2NjY2I4NjQwNDA5OTc0MDNhNWIxYmQ1MiJ9fX0=";
        }
        return "error";
    }

    @Nonnull
    protected static ItemStack[] propRecipe(SlimefunItemStack part, ItemStack stack) {
        return new ItemStack[]{null, null, null, part, null, stack, null, null, null};
    }
}

