/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.smeltery;

import io.github.sefiraat.slimetinker.infinitylib.machines.TickingMenuBlock;
import io.github.sefiraat.slimetinker.items.Materials;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.TinkersSmelteryCache;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class TinkersSmeltery
extends TickingMenuBlock {
    protected static final int[] CAST_STORE_SLOTS = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    protected static final int INPUT_SLOT = 10;
    protected static final int CAST_SLOT = 13;
    protected static final int OUTPUT_SLOT = 16;
    protected static final int PURGE_BUTTON = 32;
    protected static final int ALLOY_BUTTON = 33;
    protected static final int POUR_BUTTON = 34;
    protected static final int LAVA_INFO = 28;
    protected static final int METAL_INFO = 30;
    private static final int[] BACKGROUND_SLOTS = new int[]{27, 29, 31, 35};
    private static final int[] BACKGROUND_INPUT_SLOTS = new int[]{0, 1, 2, 9, 11, 18, 19, 20};
    private static final int[] BACKGROUND_CAST_SLOTS = new int[]{3, 4, 5, 12, 14, 21, 22, 23};
    private static final int[] BACKGROUND_OUTPUT_SLOTS = new int[]{6, 7, 8, 15, 17, 24, 25, 26};
    private final Map<Location, TinkersSmelteryCache> caches = new HashMap<Location, TinkersSmelteryCache>();

    public TinkersSmeltery(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void tick(Block block, BlockMenu blockMenu) {
        TinkersSmelteryCache cache = this.caches.get(block.getLocation());
        if (cache != null) {
            cache.process(false);
        }
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.setSize(54);
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND_SLOTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_INPUT, BACKGROUND_INPUT_SLOTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_OUTPUT, BACKGROUND_OUTPUT_SLOTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_CAST, BACKGROUND_CAST_SLOTS);
        blockMenuPreset.addItem(28, (ItemStack)GUIItems.menuLavaInfo(0, 0, 1000));
        blockMenuPreset.addItem(30, (ItemStack)GUIItems.menuMetalInfo(0, 0, 1000, null));
        blockMenuPreset.addItem(32, (ItemStack)GUIItems.MENU_PURGE);
        blockMenuPreset.addMenuClickHandler(32, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addItem(33, (ItemStack)GUIItems.MENU_ALLOY);
        blockMenuPreset.addMenuClickHandler(33, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addItem(34, (ItemStack)GUIItems.MENU_POUR);
        blockMenuPreset.addMenuClickHandler(34, (player, i, itemStack, clickAction) -> false);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{10};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{16};
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent event, @Nonnull BlockMenu blockMenu) {
        super.onBreak(event, blockMenu);
        Location location = blockMenu.getLocation();
        TinkersSmelteryCache simpleInventoryCache = this.caches.remove(location);
        if (simpleInventoryCache != null) {
            simpleInventoryCache.kill(location);
        }
        blockMenu.dropItems(location, new int[]{10});
        blockMenu.dropItems(location, CAST_STORE_SLOTS);
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
        super.onNewInstance(menu, b);
        TinkersSmelteryCache cache = new TinkersSmelteryCache(menu);
        String lavaLevel = BlockStorage.getLocationInfo((Location)menu.getLocation(), (String)"tnk-lava-level");
        if (lavaLevel != null) {
            cache.setLevelLava(Integer.parseInt(lavaLevel));
        }
        Config c = BlockStorage.getLocationInfo((Location)menu.getLocation());
        for (String key : c.getKeys()) {
            if (!key.startsWith("tnk-metal:")) continue;
            String id = key.replace("tnk-metal:", "");
            int amount = Integer.parseInt(c.getString(key));
            cache.getTankContent().put(id, amount);
        }
        this.caches.put(b.getLocation(), cache);
        menu.addMenuOpeningHandler(player -> this.validateMultiblock(menu, player));
    }

    private void validateMultiblock(BlockMenu blockMenu, Player player) {
        HashMap<String, Integer> blockMapMaster = new HashMap<String, Integer>();
        blockMapMaster.put(Materials.SEARED_BRICK_BLOCK.getItemId(), 6);
        blockMapMaster.put(Materials.SEARED_TANK.getItemId(), 1);
        blockMapMaster.put(Materials.SPOUT.getItemId(), 1);
        blockMapMaster.put(Materials.SMELTERY_CONTROLLER.getItemId(), 1);
        Location controllerLoc = blockMenu.getLocation();
        Block b = controllerLoc.getBlock();
        Map<String, Integer> blockMapXY = this.getBlockMapXY(b);
        Map<String, Integer> blockMapZY = this.getBlockMapZY(b);
        if (!blockMapXY.equals(blockMapMaster) && !blockMapZY.equals(blockMapMaster)) {
            player.sendMessage(ThemeUtils.WARNING + "This multiblock has not been setup correctly.");
            blockMenu.close();
        }
    }

    private Map<String, Integer> getBlockMapXY(Block b) {
        HashMap<String, Integer> blockMapXY = new HashMap<String, Integer>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                String id = BlockStorage.getLocationInfo((Location)b.getRelative(x, y, 0).getLocation(), (String)"id");
                if (id == null) continue;
                if (blockMapXY.containsKey(id)) {
                    blockMapXY.put(id, (Integer)blockMapXY.get(id) + 1);
                    continue;
                }
                blockMapXY.put(id, 1);
            }
        }
        return blockMapXY;
    }

    private Map<String, Integer> getBlockMapZY(Block b) {
        HashMap<String, Integer> blockMapZY = new HashMap<String, Integer>();
        for (int z = -1; z <= 1; ++z) {
            for (int y = -1; y <= 1; ++y) {
                String id = BlockStorage.getLocationInfo((Location)b.getRelative(0, y, z).getLocation(), (String)"id");
                if (id == null) continue;
                if (blockMapZY.containsKey(id)) {
                    blockMapZY.put(id, (Integer)blockMapZY.get(id) + 1);
                    continue;
                }
                blockMapZY.put(id, 1);
            }
        }
        return blockMapZY;
    }
}

