/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.events;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.items.Materials;
import io.github.sefiraat.slimetinker.runnables.event.RemoveWolf;
import io.github.sefiraat.slimetinker.utils.EntityUtils;
import io.github.sefiraat.slimetinker.utils.GeneralUtils;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.sefiraat.slimetinker.utils.WorldUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class PlayerDamagedEvents {
    private PlayerDamagedEvents() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void platesSmithium(EventFriend friend) {
        if (friend.getCause() != EntityDamageEvent.DamageCause.FIRE && friend.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK && friend.getCause() != EntityDamageEvent.DamageCause.LAVA) {
            return;
        }
        if (ThreadLocalRandom.current().nextInt(1, 5) == 1) {
            friend.setCancelEvent(true);
        }
    }

    public static void rodAdamantite(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || friend.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            friend.setDamageMod(0.0);
        }
    }

    public static void rodInfinity(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() / 2.0);
    }

    public static void rodSingSilver(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FALL) {
            friend.setDamageMod(0.0);
        }
    }

    public static void bindSlime(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FALL) {
            friend.setDamageMod(friend.getDamageMod() / 2.0);
        }
    }

    public static void bindSlimesteel(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FALL) {
            friend.setDamageMod(friend.getDamageMod() / 2.0);
        }
    }

    public static void rodReinforcedSlimesteel(EventFriend friend) {
        if (!ItemUtils.isTinkersBroken(friend.getTool())) {
            ItemUtils.damageTinkersItem(friend.getTool(), (int)friend.getInitialDamage());
            friend.setDamageMod(friend.getDamageMod() / 2.0);
        }
    }

    public static void headFerrosilicon(EventFriend friend) {
        friend.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 40, 0, true));
    }

    public static void bindGhostly(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            friend.setDamageMod(0.0);
        }
    }

    public static void headMagThor(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.LAVA || friend.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            friend.setDamageMod(0.0);
        }
    }

    public static void bindRubber(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
            friend.setDamageMod(0.0);
        }
    }

    public static void bindCarbonMesh(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() - 0.33);
    }

    public static void headIridium(EventFriend friend) {
        Player p = friend.getPlayer();
        if (friend.getInitialDamage() >= p.getHealth()) {
            ItemStack i = friend.getTool();
            if (!ItemUtils.onCooldown(i, "PROTECTIVE")) {
                p.setHealth(1.0);
                friend.setDamageMod(0.0);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)20, (int)20, (int)20), 2.0f);
                p.getWorld().spawnParticle(Particle.REDSTONE, p.getLocation(), 30, 3.0, 3.0, 3.0, 1.0, (Object)dustOptions);
                Particle.DustOptions dustOptions2 = new Particle.DustOptions(Color.fromRGB((int)1, (int)1, (int)1), 2.0f);
                p.getWorld().spawnParticle(Particle.REDSTONE, p.getLocation(), 30, 3.0, 3.0, 3.0, 1.0, (Object)dustOptions2);
                Particle.DustOptions dustOptions3 = new Particle.DustOptions(Color.fromRGB((int)40, (int)40, (int)40), 2.0f);
                p.getWorld().spawnParticle(Particle.REDSTONE, p.getLocation(), 30, 3.0, 3.0, 3.0, 1.0, (Object)dustOptions3);
                p.sendMessage(ThemeUtils.WARNING + "Protective has saved you from death. It's now on cooldown - take care!");
                ItemUtils.setCooldown(i, "PROTECTIVE", 1200000L);
            } else {
                p.sendMessage(ThemeUtils.WARNING + "Skill is on cooldown");
            }
        }
    }

    public static void linksZinc(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.CONTACT) {
            friend.setDamageMod(0.0);
        }
    }

    public static void plateBrass(EventFriend friend) {
        ItemStack itemStack = friend.getActiveStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return;
        }
        Damageable damagable = (Damageable)itemMeta;
        short maxDurability = itemStack.getType().getMaxDurability();
        int damage = damagable.getDamage();
        float dmgPerc = (float)damage / (float)maxDurability;
        if (dmgPerc <= 0.0f) {
            friend.setDamageMod(friend.getDamageMod() + 0.25);
        } else if ((double)dmgPerc <= 0.1) {
            friend.setDamageMod(friend.getDamageMod() + 0.2);
        } else if ((double)dmgPerc <= 0.2) {
            friend.setDamageMod(friend.getDamageMod() + 0.15);
        } else if ((double)dmgPerc <= 0.3) {
            friend.setDamageMod(friend.getDamageMod() + 0.1);
        } else if ((double)dmgPerc <= 0.4) {
            friend.setDamageMod(friend.getDamageMod() + 0.05);
        } else if ((double)dmgPerc <= 0.5) {
            friend.setDamageMod(friend.getDamageMod() + 0.0);
        } else if ((double)dmgPerc <= 0.6) {
            friend.setDamageMod(friend.getDamageMod() - 0.05);
        } else if ((double)dmgPerc <= 0.7) {
            friend.setDamageMod(friend.getDamageMod() - 0.1);
        } else if ((double)dmgPerc <= 0.8) {
            friend.setDamageMod(friend.getDamageMod() - 0.15);
        } else if ((double)dmgPerc <= 0.9) {
            friend.setDamageMod(friend.getDamageMod() - 0.2);
        } else if (dmgPerc <= 1.0f) {
            friend.setDamageMod(friend.getDamageMod() - 0.25);
        }
    }

    public static void plateCopper(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + 0.25);
    }

    public static void linksTin(EventFriend friend) {
        EntityUtils.increaseEffect(PotionEffectType.ABSORPTION, friend.getPotionEffects());
    }

    public static void gambesonSlime(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FALL) {
            friend.setDamageMod(friend.getDamageMod() - 0.25);
        }
    }

    public static void plateSilver(EventFriend friend) {
        NamespacedKey key = Keys.STOP_EVENTS;
        Player player = friend.getPlayer();
        if (!PersistentDataAPI.hasInt((PersistentDataHolder)player, (NamespacedKey)key) && friend.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
            PersistentDataAPI.setInt((PersistentDataHolder)player, (NamespacedKey)key, (int)1);
            friend.setCancelEvent(true);
            int rnd = ThreadLocalRandom.current().nextInt(3, 7);
            for (int i = 0; i <= rnd; ++i) {
                int rndx = ThreadLocalRandom.current().nextInt(-3, 4);
                int rndz = ThreadLocalRandom.current().nextInt(-3, 4);
                player.getWorld().strikeLightningEffect(player.getLocation().clone().add((double)rndx, 0.0, (double)rndz));
            }
            PersistentDataAPI.remove((PersistentDataHolder)player, (NamespacedKey)key);
        }
    }

    public static void plateDuralium(EventFriend friend) {
        if (ItemUtils.isTinkersBroken(friend.getActiveStack())) {
            friend.setDamageMod(friend.getDamageMod() + 0.2);
        }
    }

    public static void linksAluBronze(EventFriend friend) {
        Player p = friend.getPlayer();
        if (p.getHealth() <= p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 100, 2));
        }
    }

    public static void linksAluBrass(EventFriend friend) {
        int rnd = ThreadLocalRandom.current().nextInt(0, 30);
        if (rnd == 0) {
            int rndX = ThreadLocalRandom.current().nextInt(-25, 26);
            int rndY = ThreadLocalRandom.current().nextInt(0, 5);
            int rndZ = ThreadLocalRandom.current().nextInt(-25, 26);
            Player p = friend.getPlayer();
            Location location = p.getLocation().clone().add((double)rndX, (double)rndY, (double)rndZ);
            if (p.getWorld().getBlockAt(location).getType() == Material.AIR) {
                p.teleport(location);
                p.getWorld().playEffect(friend.getPlayer().getLocation(), Effect.ENDEREYE_LAUNCH, 10);
            }
        }
    }

    public static void plateAluminum(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + 0.5);
    }

    public static void plateSteel(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || friend.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            friend.setDamageMod(friend.getDamageMod() - 0.25);
        }
    }

    public static void linksBillon(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.HOT_FLOOR) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksBrass(EventFriend friend) {
        Player p = friend.getPlayer();
        if (p.getHealth() <= p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2));
        }
    }

    public static void plateMetal(EventFriend friend) {
        int rnd = ThreadLocalRandom.current().nextInt(0, 30);
        if (rnd == 0) {
            Player p = friend.getPlayer();
            p.getWorld().spawnEntity(p.getLocation().clone().add(1.0, 0.0, 1.0), EntityType.IRON_GOLEM);
        }
    }

    public static void plateAluBrass(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.MAGIC) {
            friend.setDamageMod(friend.getDamageMod() - 0.25);
        }
    }

    public static void plateTin(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.POISON) {
            friend.setCancelEvent(true);
        }
    }

    public static void plateGold(EventFriend friend) {
        if (GeneralUtils.testChance(1, 100)) {
            Location l = friend.getPlayer().getLocation();
            l.getWorld().dropItemNaturally(l, new ItemStack(Material.GOLD_NUGGET));
        }
    }

    public static void linksDuralium(EventFriend friend) {
        if (GeneralUtils.testChance(1, 10)) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksDamSteel(EventFriend friend) {
        Entity e;
        if (friend.getCause() == EntityDamageEvent.DamageCause.THORNS && (e = friend.getDamagingEntity()) instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)e;
            friend.setCancelEvent(true);
            l.damage(friend.getInitialDamage());
        }
    }

    public static void plateSolder(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksReinforced(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.WITHER) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksSingZinc(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.CONTACT) {
            Player p = friend.getPlayer();
            friend.setDamageMod(0.0);
            p.setHealth(Math.min(p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), p.getHealth() + friend.getInitialDamage()));
        }
    }

    public static void plateSingCopper(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + 0.5);
    }

    public static void linksSingTin(EventFriend friend) {
        EntityUtils.increaseEffect(PotionEffectType.ABSORPTION, friend.getPotionEffects(), 2);
    }

    public static void linksMythril(EventFriend friend) {
        if (GeneralUtils.testChance(1, 20)) {
            Player p = friend.getPlayer();
            Wolf w = (Wolf)p.getWorld().spawnEntity(p.getLocation(), EntityType.WOLF);
            w.setOwner((AnimalTamer)p);
            if (friend.getDamagingEntity() != null) {
                w.setTarget((LivingEntity)friend.getDamagingEntity());
            }
            RemoveWolf task = new RemoveWolf(w);
            task.runTaskLater((Plugin)SlimeTinker.getInstance(), 500L);
        }
    }

    public static void linksMagSteel(EventFriend friend) {
        if (GeneralUtils.testChance(5, 100)) {
            friend.setCancelEvent(true);
            EntityUtils.increaseEffect(PotionEffectType.ABSORPTION, friend.getPotionEffects());
        }
    }

    public static void plateSingSilver(EventFriend friend) {
        NamespacedKey key = Keys.STOP_EVENTS;
        Player player = friend.getPlayer();
        if (!PersistentDataAPI.hasInt((PersistentDataHolder)player, (NamespacedKey)key) && friend.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
            PersistentDataAPI.setInt((PersistentDataHolder)player, (NamespacedKey)key, (int)1);
            friend.setCancelEvent(true);
            int rnd = ThreadLocalRandom.current().nextInt(7, 20);
            for (int i = 0; i <= rnd; ++i) {
                int rndx = ThreadLocalRandom.current().nextInt(-5, 6);
                int rndz = ThreadLocalRandom.current().nextInt(-5, 6);
                player.getWorld().strikeLightningEffect(player.getLocation().clone().add((double)rndx, 0.0, (double)rndz));
            }
            PersistentDataAPI.remove((PersistentDataHolder)player, (NamespacedKey)key);
        }
    }

    public static void plateAdamantite(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) {
            friend.setDamageMod(friend.getDamageMod() - 0.25);
        }
    }

    public static void plateSingAluminium(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + 0.5);
    }

    public static void linksMetal(EventFriend friend) {
        if (GeneralUtils.testChance(1, 5) && friend.getDamagingEntity() instanceof LivingEntity) {
            friend.setCancelEvent(true);
            LivingEntity l = (LivingEntity)friend.getDamagingEntity();
            l.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
            l.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, l.getLocation(), 3, 0.2, 0.2, 0.2);
            l.damage(friend.getInitialDamage(), (Entity)friend.getPlayer());
        }
    }

    public static void linksTitanium(EventFriend friend) {
        EntityDamageEvent.DamageCause c = friend.getCause();
        if (c == EntityDamageEvent.DamageCause.LAVA || c == EntityDamageEvent.DamageCause.FIRE || c == EntityDamageEvent.DamageCause.FIRE_TICK || c == EntityDamageEvent.DamageCause.HOT_FLOOR) {
            friend.setCancelEvent(true);
        }
    }

    public static void plateFortune(EventFriend friend) {
        if (friend.getInitialDamage() >= 1.0 && GeneralUtils.testChance(1, 200)) {
            int roll = GeneralUtils.roll(100);
            ItemStack i = roll < 5 ? Materials.NUGGET_CAST_ADAMANTITE.clone() : (roll < 10 ? Materials.NUGGET_CAST_TITANIUM.clone() : (roll < 15 ? Materials.NUGGET_CAST_MYTHRIL.clone() : (roll < 20 ? Materials.NUGGET_CAST_MAGNONIUM.clone() : (roll < 25 ? Materials.NUGGET_CAST_MAGSTEEL.clone() : (roll < 30 ? Materials.NUGGET_CAST_REINFORCED.clone() : (roll < 35 ? Materials.NUGGET_CAST_REDSTONE_ALLOY.clone() : (roll < 40 ? Materials.NUGGET_CAST_ALU_BRASS.clone() : (roll < 50 ? Materials.NUGGET_CAST_COR_BRONZE.clone() : (roll < 55 ? Materials.NUGGET_CAST_HARD_METAL.clone() : (roll < 60 ? Materials.NUGGET_CAST_ALU_BRONZE.clone() : (roll < 65 ? Materials.NUGGET_CAST_DAMASCUS_STEEL.clone() : (roll < 70 ? Materials.NUGGET_CAST_COBALT.clone() : (roll < 75 ? Materials.NUGGET_CAST_NICKEL.clone() : (roll < 80 ? Materials.NUGGET_CAST_BILLON.clone() : (roll < 85 ? Materials.NUGGET_CAST_SOLDER.clone() : (roll < 90 ? Materials.NUGGET_CAST_DURALIUM.clone() : (roll < 95 ? Materials.NUGGET_CAST_STEEL.clone() : Materials.NUGGET_CAST_COAL.clone())))))))))))))))));
            WorldUtils.dropItem(i, friend.getPlayer());
        }
    }

    public static void plateInfinity(EventFriend friend) {
        NamespacedKey k;
        ItemStack i = friend.getActiveStack();
        ItemMeta im = i.getItemMeta();
        double d = PersistentDataAPI.getDouble((PersistentDataHolder)im, (NamespacedKey)(k = Keys.ARMOUR_INFINITE_CAPACITY_STORED), (double)0.0);
        if (d < 5.0) {
            d = Math.min(5.0, d + friend.getInitialDamage() / 10.0);
            PersistentDataAPI.setDouble((PersistentDataHolder)im, (NamespacedKey)k, (double)d);
            i.setItemMeta(im);
        }
    }

    public static void linksSingInfinity(EventFriend friend) {
        friend.setInfinity(friend.getInfinity() + 1);
        if (friend.getInfinity() >= 4) {
            friend.setDamageOverride(1.0);
        }
    }

    public static void headReinforcedDraconium(EventFriend friend) {
        if (friend.getDamagingEntity() instanceof EnderDragon) {
            Player player = friend.getPlayer();
            int stacks = PersistentDataAPI.getInt((PersistentDataHolder)player, (NamespacedKey)Keys.DRACONIC_STACKS, (int)0);
            PersistentDataAPI.setInt((PersistentDataHolder)player, (NamespacedKey)Keys.DRACONIC_STACKS, (int)(stacks + 1));
            PersistentDataAPI.setLong((PersistentDataHolder)player, (NamespacedKey)Keys.DRACONIC_DURATION, (long)(System.currentTimeMillis() + 15000L));
        }
    }

    public static void plateSingInfinity(EventFriend friend) {
        ItemStack i = friend.getActiveStack();
        ItemMeta im = i.getItemMeta();
        NamespacedKey k = Keys.ARMOUR_INFINITLY_POWERFUL_STORED;
        int d = PersistentDataAPI.getInt((PersistentDataHolder)im, (NamespacedKey)k, (int)0);
        d = (int)((double)d + friend.getInitialDamage());
        int numberOfEnchants = 0;
        Iterator iterator = i.getEnchantments().values().iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            numberOfEnchants += level;
        }
        int requirement = 2000 + 2000 * numberOfEnchants;
        if (d >= requirement) {
            ItemUtils.incrementRandomEnchant(i, im);
            PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)k, (int)0);
        } else {
            PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)k, (int)d);
        }
        i.setItemMeta(im);
    }

    public static void linksMagic(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.DRAGON_BREATH) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksInfinity(EventFriend friend) {
        if (friend.getDamagingEntity() != null && GeneralUtils.testChance(20, 100)) {
            friend.setDamageMod(0.0);
            if (friend.getDamagingEntity() instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)friend.getDamagingEntity();
                e.damage(friend.getInitialDamage(), (Entity)friend.getPlayer());
                e.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, e.getLocation(), 5, 0.5, 0.5, 0.5);
            }
        }
    }

    public static void linksMagnonium(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
            friend.setCancelEvent(true);
        }
    }

    public static void plateVoid(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.VOID) {
            friend.setCancelEvent(true);
            Player player = friend.getPlayer();
            player.teleport(friend.getPlayer().getLocation().add(0.0, 200.0, 0.0));
            player.setNoDamageTicks(100);
        }
    }

    public static void plateSingGold(EventFriend friend) {
        if (friend.getInitialDamage() >= 1.0 && GeneralUtils.testChance(1, 100)) {
            WorldUtils.dropItem(new ItemStack(Material.GOLD_NUGGET, GeneralUtils.roll(4)), friend.getPlayer());
        }
    }

    public static void plateSingIron(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || friend.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            Player p = friend.getPlayer();
            friend.setCancelEvent(true);
            p.setHealth(Math.min(p.getHealth() + friend.getInitialDamage(), p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        }
    }

    public static void linksVoid(EventFriend friend) {
        Entity e = friend.getDamagedEntity();
        if (e instanceof EnderDragon || e instanceof Enderman || e instanceof Shulker) {
            friend.setDamageMod(friend.getDamageMod() - 0.1);
        }
    }

    public static void hyperbolic(EventFriend friend) {
        friend.setHyperbolic(friend.getHyperbolic() + 1);
        if (friend.getHyperbolic() >= 8) {
            double dmg;
            NamespacedKey k;
            ItemStack i = friend.getActiveStack();
            ItemMeta im = i.getItemMeta();
            int amount = PersistentDataAPI.getInt((PersistentDataHolder)im, (NamespacedKey)(k = Keys.ARMOUR_HYPERBOLIC_STORED), (int)0);
            if ((double)amount >= (dmg = friend.getInitialDamage() * friend.getDamageMod())) {
                friend.setCancelEvent(true);
                amount = (int)((double)amount - dmg);
            }
            PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)k, (int)amount);
            i.setItemMeta(im);
        }
    }

    public static void plateStainlessSteel(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() - 0.05);
    }

    public static void linksReinforcedSlimesteel(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && GeneralUtils.testChance(10, 100)) {
            friend.setCancelEvent(true);
        }
    }

    public static void linksOsmium(EventFriend friend) {
        if (GeneralUtils.testChance(5, 100)) {
            Player p = friend.getPlayer();
            friend.setCancelEvent(true);
            p.setHealth(Math.min(p.getHealth() + friend.getInitialDamage(), p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        }
    }

    public static void plateOsmium(EventFriend friend) {
        if (friend.getDamagingEntity() != null) {
            EntityUtils.push((LivingEntity)friend.getDamagingEntity(), friend.getPlayer().getLocation(), 0.2);
        }
    }

    public static void gambesonSlimeSteel(EventFriend friend) {
        if (friend.getCause() == EntityDamageEvent.DamageCause.FALL) {
            friend.setCancelEvent(true);
        }
    }

    public static void plateReinforcedSlimesteel(EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + 0.1);
    }

    public static void linksMagThor(EventFriend friend) {
        if (GeneralUtils.testChance(1, 5)) {
            PotionEffect haste;
            Player p = friend.getPlayer();
            PotionEffect speed = p.hasPotionEffect(PotionEffectType.SPEED) ? p.getPotionEffect(PotionEffectType.SPEED) : null;
            PotionEffect potionEffect = haste = p.hasPotionEffect(PotionEffectType.FAST_DIGGING) ? p.getPotionEffect(PotionEffectType.FAST_DIGGING) : null;
            if (speed == null) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, 0));
            } else {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 200, Math.min(speed.getAmplifier() + 1, 9)));
            }
            if (haste == null) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 200, 1));
            } else {
                p.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 200, Math.min(haste.getAmplifier() + 2, 19)));
            }
        }
    }

    public static void plateIridium(EventFriend friend) {
        Player p = friend.getPlayer();
        Entity e = friend.getDamagingEntity();
        if (e instanceof Mob) {
            if (e.getType() == EntityType.GUARDIAN) {
                return;
            }
            ((Mob)e).damage(friend.getInitialDamage() * 0.1, (Entity)p);
            friend.setDamageMod(friend.getDamageMod() - 0.1);
        }
    }

    public static void linksMixedMetal(EventFriend friend) {
        Entity e;
        if (GeneralUtils.testChance(1, 5) && (e = friend.getDamagingEntity()) != null) {
            Player p = friend.getPlayer();
            Location pl = p.getLocation();
            Location el = e.getLocation();
            p.teleport(el);
            e.teleport(pl);
        }
    }

    public static void linksRefinedIron(EventFriend friend) {
        Entity e = friend.getDamagingEntity();
        if (e instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)e;
            l.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 200, 9));
        }
    }

    public static void plateScrap(EventFriend friend) {
        if (GeneralUtils.testChance(5, 100)) {
            friend.getPlayer().damage(100.0, (Entity)friend.getPlayer());
        }
    }

    public static void plateMagThor(EventFriend friend) {
        Entity e = friend.getDamagingEntity();
        if (e instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)e;
            int a = l.hasPotionEffect(PotionEffectType.POISON) ? l.getPotionEffect(PotionEffectType.POISON).getAmplifier() + 1 : 0;
            l.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 200, Math.max(a, 9)));
        }
    }

    public static void linksIridium(EventFriend friend) {
        ItemStack i = friend.getActiveStack();
        ItemMeta im = i.getItemMeta();
        NamespacedKey k = Keys.ARMOUR_UNCONVENTIONAL_STORED;
        int amount = PersistentDataAPI.getInt((PersistentDataHolder)im, (NamespacedKey)k, (int)0);
        PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)k, (int)((int)((double)amount + friend.getInitialDamage())));
        i.setItemMeta(im);
    }

    public static void linksScrap(EventFriend friend) {
        Player p = friend.getPlayer();
        if (GeneralUtils.testChance(1, 10)) {
            ItemStack i = friend.getActiveStack();
            ItemStack drop = i.clone();
            i.setAmount(0);
            WorldUtils.dropItem(drop, p);
        } else {
            friend.incrementItemExpMod(2.0);
        }
    }

    public static void plateIron(EventFriend friend) {
        if ((friend.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || friend.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && GeneralUtils.testChance(1, 8)) {
            friend.setCancelEvent(true);
        }
    }
}

