/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.events;

import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.listeners.BlockMap;
import io.github.sefiraat.slimetinker.managers.MemoryManager;
import io.github.sefiraat.slimetinker.utils.GeneralUtils;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class BlockBreakEvents {
    private BlockBreakEvents() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void rodSmithium(EventFriend friend) {
        Player player = friend.getPlayer();
        long hasteEnd = MemoryManager.getInstance().getHasteBurstEnd(player.getUniqueId());
        long timeNow = System.currentTimeMillis();
        if (hasteEnd == 0L) {
            return;
        }
        if (hasteEnd < timeNow) {
            MemoryManager.getInstance().removeHasteBurst(player.getUniqueId());
            return;
        }
        PotionEffect effect = player.getPotionEffect(PotionEffectType.FAST_DIGGING);
        if (effect != null && effect.getAmplifier() >= 9) {
            return;
        }
        int chanceUpper = 2 * ((effect == null ? 0 : effect.getAmplifier()) + 1);
        if (ThreadLocalRandom.current().nextInt(1, chanceUpper) == 1) {
            int nextLevel = effect == null ? 0 : Math.min(effect.getAmplifier() + 1, 9);
            int durationTicks = (int)(hasteEnd - timeNow) / 50;
            PotionEffect newEffect = new PotionEffect(PotionEffectType.FAST_DIGGING, durationTicks, nextLevel);
            player.addPotionEffect(newEffect);
            player.sendMessage(ThemeUtils.SUCCESS + "Haste Burst has hit level " + (nextLevel + 1) + "!");
        }
    }

    public static void headNice(EventFriend friend) {
        friend.getPlayer().sendMessage(ThemeUtils.WARNING + "Nice");
    }

    public static void headCorbronze(EventFriend friend) {
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>(friend.getAddDrops());
        Iterator recipeIterator = Bukkit.recipeIterator();
        block0: while (recipeIterator.hasNext()) {
            ItemStack ni;
            Recipe recipe = (Recipe)recipeIterator.next();
            if (!(recipe instanceof FurnaceRecipe)) continue;
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
            for (ItemStack i : friend.getDrops()) {
                if (!furnaceRecipe.getInputChoice().test(i)) continue;
                ni = recipe.getResult().clone();
                ni.setAmount(i.getAmount());
                newDrops.add(ni);
                friend.getRemoveDrops().add(i);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)130, (int)100, (int)30), 2.0f);
                friend.getBlock().getWorld().spawnParticle(Particle.REDSTONE, friend.getBlock().getLocation(), 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
                break;
            }
            if (friend.getAddDrops().isEmpty()) continue;
            for (ItemStack i : friend.getAddDrops()) {
                if (!i.isSimilar(((FurnaceRecipe)recipe).getInput())) continue;
                ni = recipe.getResult().clone();
                ni.setAmount(i.getAmount());
                newDrops.add(ni);
                friend.getRemoveDrops().add(i);
                continue block0;
            }
        }
        friend.setAddDrops(newDrops);
    }

    public static void headCopper(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 1.0);
    }

    public static void rodAluBrass(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 0.5);
        friend.setPlayerExpMod(friend.getPlayerExpMod() + 0.5);
    }

    public static void rodAluminum(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 0.5);
    }

    public static void headDuralium(EventFriend friend) {
        friend.setToolExpMod(0.0);
    }

    public static void headSingCopper(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 2.0);
    }

    public static void headSingInfinity(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 2.0);
    }

    public static void rodMetal(EventFriend friend) {
        friend.setMetalCheck(true);
    }

    public static void headFortune(EventFriend friend) {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>(friend.getAddDrops());
        for (ItemStack i : friend.getDrops()) {
            if (i.getAmount() <= 1) continue;
            ItemStack i2 = i.clone();
            i2.setAmount(i.getAmount() * 2);
            c.add(i2);
            friend.getRemoveDrops().add(i);
        }
        friend.setAddDrops(c);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)130, (int)30, (int)120), 2.0f);
        friend.getBlock().getWorld().spawnParticle(Particle.REDSTONE, friend.getBlock().getLocation(), 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
    }

    public static void rodEarth(EventFriend friend) {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>(friend.getAddDrops());
        for (ItemStack i : friend.getDrops()) {
            Material m = null;
            int amount = 1;
            switch (i.getType()) {
                case COBBLESTONE: 
                case ANDESITE: 
                case GRANITE: 
                case DIORITE: {
                    m = Material.GRAVEL;
                    break;
                }
                case BONE_BLOCK: {
                    m = Material.BONE_MEAL;
                    amount = 9;
                    break;
                }
                case SANDSTONE: {
                    m = Material.SAND;
                    amount = 4;
                    break;
                }
                case RED_SANDSTONE: {
                    m = Material.RED_SAND;
                    amount = 4;
                    break;
                }
                case PRISMARINE_BRICKS: {
                    m = Material.PRISMARINE;
                    amount = 2;
                    break;
                }
                case PRISMARINE: {
                    m = Material.PRISMARINE_SHARD;
                    amount = 4;
                    break;
                }
                case NETHER_WART_BLOCK: {
                    m = Material.NETHER_WART;
                    amount = 9;
                    break;
                }
                case QUARTZ_BLOCK: {
                    m = Material.QUARTZ;
                    amount = 4;
                    break;
                }
            }
            if (m != null) {
                c.add(new ItemStack(m, amount));
                friend.getRemoveDrops().add(i);
            }
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)30, (int)130, (int)40), 2.0f);
            friend.getBlock().getWorld().spawnParticle(Particle.REDSTONE, friend.getBlock().getLocation(), 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
        }
        friend.setAddDrops(c);
    }

    public static void headMagnonium(EventFriend friend) {
        if (ThreadLocalRandom.current().nextInt(1, 6) == 1) {
            friend.getPlayer().dropItem(true);
        }
    }

    public static void headAdamantite(EventFriend friend) {
        friend.setPlayerExpMod(friend.getPlayerExpMod() + 1.0);
    }

    public static void rodSingAluminum(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + 1.0);
    }

    public static void headVoid(EventFriend friend) {
        Block b;
        String toolType = ItemUtils.getToolTypeName(friend.getTool());
        Map<Material, String> m = BlockMap.getMaterialMap();
        if (m.containsKey((b = friend.getBlock()).getType()) && m.get(b.getType()).equals(toolType) && GeneralUtils.testChance(1, 10)) {
            int rnd2 = GeneralUtils.roll(1000);
            ItemStack i = rnd2 > 975 ? new ItemStack(Material.ANCIENT_DEBRIS) : (rnd2 > 900 ? new ItemStack(Material.DIAMOND) : (rnd2 > 800 ? new ItemStack(Material.LAPIS_LAZULI) : (rnd2 > 700 ? new ItemStack(Material.REDSTONE) : (rnd2 > 550 ? new ItemStack(Material.GOLD_ORE) : (rnd2 > 400 ? new ItemStack(Material.IRON_ORE) : new ItemStack(Material.COAL))))));
            friend.getAddDrops().add(i);
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)60, (int)60, (int)60), 2.0f);
            friend.getBlock().getWorld().spawnParticle(Particle.REDSTONE, friend.getBlock().getLocation(), 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
        }
    }

    public static void headUnpatentabilum(EventFriend friend) {
        if (GeneralUtils.day(friend.getPlayer().getWorld())) {
            friend.setPlayerExpMod(friend.getPlayerExpMod() + 1.0);
            friend.setToolExpMod(friend.getToolExpMod() + 1.0);
        }
    }

    public static void headReinforcedSlimesteel(EventFriend friend) {
        friend.setBlocksIntoInv(true);
    }

    public static void bindSilicon(EventFriend friend) {
        friend.setToolExpMod(friend.getToolExpMod() + friend.getToolExpMod() * ((double)friend.getActiveLevel() * 0.05));
    }

    public static void headScrap(EventFriend friend) {
        friend.setToolExpMod(0.0);
    }

    public static void linksHardened(EventFriend friend) {
        List<SlimefunItemStack> list = Arrays.asList(SlimefunItems.MAGIC_LUMP_1, SlimefunItems.MAGIC_LUMP_2, SlimefunItems.ENDER_LUMP_1, SlimefunItems.ENDER_LUMP_2, SlimefunItems.PURE_ORE_CLUSTER, SlimefunItems.SIFTED_ORE, SlimefunItems.GILDED_IRON, SlimefunItems.CARBON, SlimefunItems.COMPRESSED_CARBON, SlimefunItems.CARBON_CHUNK);
        if (GeneralUtils.testChance(1, 200)) {
            friend.getAddDrops().add((ItemStack)list.get(GeneralUtils.roll(list.size(), false)));
        }
    }

    public static void plateBronze(EventFriend friend) {
        Optional opStack;
        Block b = friend.getBlock();
        if (SlimefunTag.CROPS.isTagged((Keyed)b.getType()) && (opStack = b.getDrops().stream().findFirst()).isPresent()) {
            ItemStack i = (ItemStack)opStack.get();
            i.setAmount(1);
            b.getWorld().dropItem(b.getLocation().clone().add(0.5, 0.5, 0.5), i);
        }
    }

    public static void linksAdamantite(EventFriend friend) {
        friend.incrementItemExpMod(0.1);
        friend.setPlayerExpMod(friend.getPlayerExpMod() + 0.1);
    }

    public static void binderLeather(EventFriend friend) {
        friend.incrementItemExpMod(0.5);
    }
}

