/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.listeners;

import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.infinitylib.common.StackUtils;
import io.github.sefiraat.slimetinker.items.Materials;
import io.github.sefiraat.slimetinker.listeners.FakeItemDamageEvent;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.GeneralUtils;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class DurabilityListener
implements Listener {
    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        ItemStack damagedItem = event.getItem();
        EventFriend friend = new EventFriend(event.getPlayer(), TraitEventType.DURABILITY);
        String armourTypeName = ItemUtils.getArmourTypeName(damagedItem);
        if (ItemUtils.isTinkers(damagedItem)) {
            if (ItemUtils.isTool(damagedItem)) {
                EventChannels.checkTool(friend);
            } else if (armourTypeName != null) {
                switch (armourTypeName) {
                    case "HELMET": {
                        EventChannels.checkHelm(friend);
                        break;
                    }
                    case "CHESTPLATE": {
                        EventChannels.checkChestplate(friend);
                        break;
                    }
                    case "LEGGINGS": {
                        EventChannels.checkLeggings(friend);
                        break;
                    }
                    case "BOOTS": {
                        EventChannels.checkBoots(friend);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        } else {
            return;
        }
        this.modChecks(damagedItem, event);
        EventChannels.settlePotionEffects(friend);
        if (friend.isCancelEvent()) {
            event.setCancelled(true);
        }
        ItemMeta im = event.getItem().getItemMeta();
        Damageable damageable = (Damageable)im;
        event.setDamage((int)Math.ceil((double)event.getDamage() * friend.getDurabilityMod()));
        if (damageable.getDamage() + event.getDamage() >= event.getItem().getType().getMaxDurability()) {
            damageable.setDamage(event.getItem().getType().getMaxDurability() - 1);
            damagedItem.setItemMeta(im);
            event.setCancelled(true);
        } else if (event instanceof FakeItemDamageEvent) {
            damageable.setDamage(damageable.getDamage() + event.getDamage());
            damagedItem.setItemMeta(im);
        }
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent event) {
        ItemStack damagedItem = event.getBrokenItem();
        if (!ItemUtils.isTool(damagedItem)) {
            return;
        }
        ItemStack newItem = damagedItem.clone();
        ItemMeta im = newItem.getItemMeta();
        assert (im != null);
        Damageable damageable = (Damageable)im;
        damageable.setDamage(damagedItem.getType().getMaxDurability() - 1);
        event.getPlayer().getInventory().addItem(new ItemStack[]{newItem});
    }

    private void modChecks(ItemStack damagedItem, PlayerItemDamageEvent event) {
        Map<String, Integer> modLevels = Modifications.getAllModLevels(damagedItem);
        if (modLevels.containsKey(StackUtils.getIdOrType((ItemStack)Materials.MOD_PLATE))) {
            this.modCheckPlate(damagedItem, modLevels.get(StackUtils.getIdOrType((ItemStack)Materials.MOD_PLATE)), event);
        }
    }

    private void modCheckPlate(@Nonnull ItemStack damagedItem, int level, PlayerItemDamageEvent event) {
        if (ItemUtils.isReinforced(damagedItem)) {
            level *= 2;
        }
        if (GeneralUtils.testChance(level, 10)) {
            event.setCancelled(true);
        }
    }
}

