/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.tinkermaterials.elements;

import com.google.common.base.Preconditions;
import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.itemgroups.ItemGroups;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterial;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.DummySmelteryAlloy;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.sefiraat.slimetinker.utils.enums.ThemeItemType;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class Alloy {
    private final Map<String, Integer> alloyMap = new HashMap<String, Integer>();
    private final SlimefunItemStack[] recipe;
    private TinkerMaterial parent;
    private SlimefunItemStack itemStack;
    private SlimefunItem item;

    public Alloy(SlimefunItemStack[] recipe) {
        this.recipe = recipe;
    }

    public void setupAlloy(TinkerMaterial parent) {
        this.parent = parent;
        String titName = ThemeUtils.toTitleCase(parent.getId());
        this.itemStack = ThemeUtils.themedItemStack(parent.getId() + "_ALLOY", parent.getLiquidTexture(), ThemeItemType.MOLTEN_METAL, "Molten " + titName, ThemeUtils.PASSIVE + "A molten alloy metal of " + titName);
        SlimefunItemStack[] alloyRecipe = parent.getAlloyRecipe();
        Preconditions.checkNotNull((Object)alloyRecipe, (Object)"Alloy recipe is null. SefiDumb\u2122");
        this.item = new SlimefunItem((ItemGroup)ItemGroups.ALLOYS, this.itemStack, DummySmelteryAlloy.TYPE, (ItemStack[])alloyRecipe);
        this.item.register((SlimefunAddon)SlimeTinker.getInstance());
        for (SlimefunItemStack i : parent.getAlloyRecipe()) {
            this.alloyMap.put(i.getItemId().replace("_LIQUID", ""), i.getAmount());
        }
    }

    public Map<String, Integer> getAlloyMap() {
        return this.alloyMap;
    }

    public SlimefunItemStack[] getRecipe() {
        return this.recipe;
    }

    public TinkerMaterial getParent() {
        return this.parent;
    }

    public SlimefunItemStack getItemStack() {
        return this.itemStack;
    }

    public SlimefunItem getItem() {
        return this.item;
    }
}

