/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.events;

import com.google.common.base.Preconditions;
import io.github.sefiraat.networks.slimefun.network.grid.NetworkGrid;
import io.github.sefiraat.networks.slimefun.tools.NetworkRemote;
import io.github.sefiraat.networks.utils.Theme;
import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.ActiveFriendElement;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.managers.MemoryManager;
import io.github.sefiraat.slimetinker.runnables.event.KingsmanSpam;
import io.github.sefiraat.slimetinker.utils.BlockUtils;
import io.github.sefiraat.slimetinker.utils.EntityUtils;
import io.github.sefiraat.slimetinker.utils.GeneralUtils;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public final class InteractionEvents {
    private InteractionEvents() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void rodSmithium(EventFriend friend) {
        Player player = friend.getPlayer();
        ItemStack itemStack = friend.getActiveStack();
        String cooldownName = "haste_burst";
        if (player.isSneaking()) {
            if (ItemUtils.onCooldown(itemStack, cooldownName)) {
                player.sendMessage(ThemeUtils.WARNING + "Haste Burst is on cooldown!");
            } else {
                player.sendMessage(ThemeUtils.SUCCESS + "Haste Burst is active");
                MemoryManager.getInstance().setHasteBurstEnd(player.getUniqueId(), 30000L);
                ItemUtils.setCooldown(itemStack, cooldownName, 300000L);
            }
        }
    }

    public static void headTessMat(EventFriend friend) {
        friend.setHypercube(friend.getHypercube() + 1);
        if (friend.getHypercube() >= 2) {
            Player p = friend.getPlayer();
            ItemStack i = friend.getActiveStack();
            ItemMeta im = i.getItemMeta();
            String cooldownName = "hypercube";
            NamespacedKey keyLoc = Keys.TRAITS_HYPERCUBE_LOCATION;
            if (p.isSneaking()) {
                PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)keyLoc, (String)GeneralUtils.serializeLocation(p.getLocation()));
                p.sendMessage(ThemeUtils.SUCCESS + "Location set!");
                i.setItemMeta(im);
            } else {
                if (ItemUtils.onCooldown(i, cooldownName)) {
                    p.sendMessage(ThemeUtils.WARNING + "Recall is on cooldown!");
                    return;
                }
                if (!PersistentDataAPI.hasString((PersistentDataHolder)im, (NamespacedKey)keyLoc)) {
                    p.sendMessage(ThemeUtils.WARNING + "You have not yet set a location to recall to!");
                    return;
                }
                String sl = PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)keyLoc);
                Location l = GeneralUtils.deserializeLocation(sl);
                p.teleport(l);
                p.sendMessage(ThemeUtils.SUCCESS + "Whoosh!");
                ItemUtils.setCooldown(i, cooldownName, 300000L);
            }
        }
    }

    public static void rodGhostly(EventFriend friend) {
        friend.setHypercube(friend.getHypercube() + 1);
    }

    public static void bindVex(EventFriend friend) {
        Player p = friend.getPlayer();
        ItemStack i = friend.getTool();
        if (!ItemUtils.onCooldown(i, "NOCLIP")) {
            int rndX = ThreadLocalRandom.current().nextInt(-25, 26);
            int rndY = ThreadLocalRandom.current().nextInt(0, 5);
            int rndZ = ThreadLocalRandom.current().nextInt(-25, 26);
            Location location = p.getLocation().clone().add((double)rndX, (double)rndY, (double)rndZ);
            if (p.getWorld().getBlockAt(location).getType() == Material.AIR && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, location, Interaction.PLACE_BLOCK)) {
                p.teleport(location);
                p.getWorld().playEffect(friend.getPlayer().getLocation(), Effect.ENDEREYE_LAUNCH, 10);
                ItemUtils.setCooldown(i, "NOCLIP", 300000L);
            } else {
                p.sendMessage(ThemeUtils.WARNING + "Couldn't teleport! Try again.");
            }
        }
    }

    public static void plateInfinity(EventFriend friend) {
        NamespacedKey k;
        ItemStack i = friend.getActiveStack();
        ItemMeta im = i.getItemMeta();
        double d = PersistentDataAPI.getDouble((PersistentDataHolder)im, (NamespacedKey)(k = Keys.ARMOUR_INFINITE_CAPACITY_STORED), (double)0.0);
        if (d > 1.0) {
            List entityList = friend.getPlayer().getNearbyEntities(3.0, 3.0, 3.0);
            for (Entity e : entityList) {
                LivingEntity l;
                if (!(e instanceof LivingEntity) || (l = (LivingEntity)e) instanceof Player && l.getUniqueId() == friend.getPlayer().getUniqueId()) continue;
                l.damage(Math.floor(d));
                l.getWorld().spawnParticle(Particle.CLOUD, l.getLocation(), 4, 0.0, 0.0, 0.0);
            }
        }
        PersistentDataAPI.setDouble((PersistentDataHolder)im, (NamespacedKey)k, (double)0.0);
        i.setItemMeta(im);
    }

    public static void linksEarth(EventFriend friend) {
        String cdName = "natural";
        Player p = friend.getPlayer();
        ItemStack i = friend.getActiveStack();
        int cdMinutes = 2;
        if (ItemUtils.onCooldown(i, cdName)) {
            p.sendMessage(ThemeUtils.WARNING + "It's Natural is on cooldown");
        } else {
            List animals = EntityUtils.getNearbyEntitiesByType(Animals.class, (Entity)p, 3.0, 3.0, 3.0);
            if (animals.size() >= 2) {
                int first = GeneralUtils.roll(animals.size(), false);
                int second = first == animals.size() ? 0 : first + 1;
                EntityUtils.makeBreed((Animals)animals.get(first));
                EntityUtils.makeBreed((Animals)animals.get(second));
            }
            ItemUtils.setCooldown(i, cdName, (long)cdMinutes * 60000L);
        }
    }

    public static void rodRefinedIron(EventFriend friend) {
        friend.setManners(1);
    }

    public static void plateRefinedIron(EventFriend friend) {
        friend.setKingsman(friend.getKingsman() + 1);
        if (friend.getManners() > 0 && friend.getKingsman() >= 4) {
            Player p = friend.getPlayer();
            ItemStack i = friend.getHelmet();
            Preconditions.checkNotNull((Object)i, (Object)"Helmet doesn't exist but has 4 stacks? I call hax");
            String cdName = "kingsman";
            if (!ItemUtils.onCooldown(i, cdName)) {
                KingsmanSpam task = new KingsmanSpam(p, 10);
                task.runTaskTimer((Plugin)SlimeTinker.getInstance(), 0L, 20L);
                ItemUtils.setCooldown(i, cdName, 1200000L);
            } else {
                p.sendMessage(ThemeUtils.WARNING + "This ability is on cooldown.");
            }
        }
    }

    public static void linksIridium(EventFriend friend) {
        ItemStack i = friend.getActiveStack();
        ItemMeta im = i.getItemMeta();
        int amount = PersistentDataAPI.getInt((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_UNCONVENTIONAL_STORED, (int)0);
        for (ItemStack i2 : friend.getPlayer().getInventory()) {
            float charge;
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)i2);
            if (!(slimefunItem instanceof Rechargeable)) {
                return;
            }
            Rechargeable rechargeable = (Rechargeable)slimefunItem;
            float maxCharge = rechargeable.getMaxItemCharge(i2);
            float amountToCharge = maxCharge - (charge = rechargeable.getItemCharge(i2));
            if ((float)amount > amountToCharge) {
                rechargeable.setItemCharge(i2, maxCharge);
                amount = (int)((float)amount - amountToCharge);
            } else {
                rechargeable.addItemCharge(i2, (float)amount);
                amount = 0;
            }
            if (amount > 0) continue;
            break;
        }
        PersistentDataAPI.setInt((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_UNCONVENTIONAL_STORED, (int)amount);
        i.setItemMeta(im);
    }

    public static void headBoomerite(EventFriend friend) {
        Block place;
        Block target;
        Player player = friend.getPlayer();
        BlockFace blockFace = BlockUtils.getTargetedBlockFace(player);
        if (blockFace != null && blockFace != BlockFace.UP && blockFace != BlockFace.DOWN && (target = player.getTargetBlock(null, 5)).getType() != Material.AIR && (place = target.getRelative(blockFace)).getType() == Material.AIR && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, place, Interaction.PLACE_BLOCK)) {
            place.setType(Material.LADDER);
            Directional directional = (Directional)place.getBlockData();
            directional.setFacing(blockFace);
            place.setBlockData((BlockData)directional);
        }
    }

    public static void headSefirite(EventFriend friend) {
        ItemStack tool = friend.getActiveStack();
        Player player = friend.getPlayer();
        if (!ItemUtils.onCooldown(tool, "celebrate")) {
            Block potential = player.getTargetBlock(null, 5).getRelative(BlockFace.UP);
            if (potential.getType() == Material.AIR && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, potential, Interaction.PLACE_BLOCK)) {
                MinecraftVersion minecraftVersion = Slimefun.getMinecraftVersion();
                potential.setType(minecraftVersion.isAtLeast(MinecraftVersion.MINECRAFT_1_17) ? Material.BLACK_CANDLE_CAKE : Material.CAKE);
                ItemUtils.setCooldown(tool, "celebrate", 3600000L);
            }
        } else {
            player.sendMessage(ThemeUtils.WARNING + "This ability is on cooldown.");
        }
    }

    public static void linksUltimaninium(EventFriend friend) {
        if (friend.getActiveFriendElement() != ActiveFriendElement.HELMET) {
            return;
        }
        Player player = friend.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() != Material.AIR) {
            return;
        }
        if (player.isSneaking() && friend.getAction() == Action.LEFT_CLICK_BLOCK) {
            Block block = friend.getBlock();
            if (block == null) {
                return;
            }
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block, Interaction.INTERACT_BLOCK) && slimefunItem instanceof NetworkGrid) {
                NetworkRemote.setGrid((ItemStack)friend.getActiveStack(), (Block)block, (Player)player);
            } else {
                player.sendMessage(Theme.ERROR + "Must be set to a Network Grid (not crafting grid).");
            }
        } else if (friend.getAction() == Action.LEFT_CLICK_AIR) {
            NetworkRemote.tryOpenGrid((ItemStack)friend.getActiveStack(), (Player)player, (int)-1);
        }
    }
}

