/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.templates;

import io.github.sefiraat.slimetinker.items.templates.ToolDefinition;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterialManager;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.text.MessageFormat;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class ToolTemplate
extends SlimefunItem
implements NotPlaceable {
    public ToolTemplate(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public String getName(ToolDefinition toolDefinition) {
        return MessageFormat.format("{0}{1}-{2}{3}-{4}{5} {6}{7}", TinkerMaterialManager.getById(toolDefinition.getHeadMaterial()).getColor(), ThemeUtils.toTitleCase(toolDefinition.getHeadMaterial()), TinkerMaterialManager.getById(toolDefinition.getBinderMaterial()).getColor(), ThemeUtils.toTitleCase(toolDefinition.getBinderMaterial()), TinkerMaterialManager.getById(toolDefinition.getRodMaterial()).getColor(), ThemeUtils.toTitleCase(toolDefinition.getRodMaterial()), ChatColor.WHITE, ThemeUtils.toTitleCase(toolDefinition.getPartType()));
    }

    public Material getMaterial(ToolDefinition toolDefinition) {
        switch (toolDefinition.getPartType()) {
            case "SHOVEL": {
                return Material.STONE_SHOVEL;
            }
            case "PICK": {
                return Material.STONE_PICKAXE;
            }
            case "AXE": {
                return Material.STONE_AXE;
            }
            case "HOE": {
                return Material.STONE_HOE;
            }
            case "SWORD": {
                return Material.STONE_SWORD;
            }
        }
        throw new IllegalStateException("Unexpected value: " + toolDefinition.getClassType());
    }

    public ItemStack getStack(ToolDefinition toolDefinition) {
        ItemStack itemStack = this.getItem().clone();
        itemStack.setType(this.getMaterial(toolDefinition));
        ItemMeta im = itemStack.getItemMeta();
        Experience.setupExpNew(im);
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_IS_TOOL, (String)"Y");
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_HEAD_TYPE, (String)toolDefinition.getClassType());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_TOOL_TYPE, (String)toolDefinition.getPartType());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_HEAD_MATERIAL, (String)toolDefinition.getHeadMaterial());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_BINDER_MATERIAL, (String)toolDefinition.getBinderMaterial());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.TOOL_INFO_ROD_MATERIAL, (String)toolDefinition.getRodMaterial());
        im.setDisplayName(this.getName(toolDefinition));
        itemStack.setItemMeta(im);
        ItemUtils.rebuildTinkerLore(itemStack);
        return itemStack;
    }
}

