/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import io.github.sefiraat.slimetinker.SlimeTinker;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;

public final class GeneralUtils {
    private GeneralUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean day(@Nonnull World world) {
        return world.getTime() > 0L && world.getTime() < 12300L;
    }

    @Nonnull
    public static String serializeLocation(@Nonnull Location l) {
        String world = Objects.requireNonNull(l.getWorld()).getName();
        double x = l.getX();
        double y = l.getY();
        double z = l.getZ();
        float w = l.getYaw();
        float p = l.getPitch();
        return world + ";" + x + ";" + y + ";" + z + ";" + w + ";" + p;
    }

    @Nonnull
    public static Location deserializeLocation(@Nonnull String s) {
        String[] split = s.split(";");
        return new Location(SlimeTinker.getInstance().getServer().getWorld(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]), Float.parseFloat(split[4]), Float.parseFloat(split[5]));
    }

    public static boolean testChance(int chance, int upper) {
        return ThreadLocalRandom.current().nextInt(1, upper + 1) <= chance;
    }

    public static int roll(int upper) {
        return GeneralUtils.roll(upper, true);
    }

    public static int roll(int upper, boolean upLimit) {
        if (upLimit) {
            ++upper;
        }
        return ThreadLocalRandom.current().nextInt(1, upper);
    }
}

