/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.tooltable;

import io.github.sefiraat.slimetinker.infinitylib.machines.TickingMenuBlock;
import io.github.sefiraat.slimetinker.items.Guide;
import io.github.sefiraat.slimetinker.items.templates.ToolDefinition;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ToolTable
extends TickingMenuBlock {
    protected static final int PREVIEW_SLOT = 38;
    protected static final int CRAFT_BUTTON = 40;
    protected static final int OUTPUT_SLOT = 42;
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 8, 9, 17, 18, 26, 27, 31, 35, 36, 44, 45, 49, 53};
    private static final int[] BACKGROUND_INPUTS = new int[]{1, 3, 5, 7, 10, 12, 14, 16, 19, 20, 21, 22, 23, 24, 25};
    private static final int[] BACKGROUND_PREVIEW = new int[]{28, 29, 30, 37, 39, 46, 47, 48};
    private static final int[] BACKGROUND_OUTPUT = new int[]{32, 33, 34, 41, 43, 50, 51, 52};
    private static final int MARKER_ROD = 2;
    private static final int MARKER_BINDER = 4;
    private static final int MARKER_HEAD = 6;
    private static final int INPUT_ROD = 11;
    private static final int INPUT_BINDING = 13;
    private static final int INPUT_HEAD = 15;

    public ToolTable(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void tick(@Nonnull Block block, @Nonnull BlockMenu blockMenu) {
        this.previewCraft(blockMenu);
    }

    protected void previewCraft(@Nonnull BlockMenu blockMenu) {
        if (blockMenu.hasViewer()) {
            ItemStack head = blockMenu.getItemInSlot(15);
            ItemStack binding = blockMenu.getItemInSlot(13);
            ItemStack rod = blockMenu.getItemInSlot(11);
            if (head == null || binding == null || rod == null) {
                this.clearPreview(blockMenu);
                return;
            }
            if (!(this.validateClass(head, "HEAD") && this.validateBinder(binding) && this.validateClass(rod, "ROD"))) {
                this.clearPreview(blockMenu);
                return;
            }
            blockMenu.replaceExistingItem(38, this.getTool(head, binding, rod));
        }
    }

    protected void clearPreview(BlockMenu blockMenu) {
        blockMenu.replaceExistingItem(38, (ItemStack)GUIItems.MENU_PREVIEW);
    }

    protected ItemStack getTool(@Nonnull ItemStack head, @Nonnull ItemStack binding, @Nonnull ItemStack rod) {
        ItemStack tool;
        ItemMeta hm = head.getItemMeta();
        ItemMeta bm = binding.getItemMeta();
        ItemMeta rm = rod.getItemMeta();
        ToolDefinition toolDefinition = new ToolDefinition((String)hm.getPersistentDataContainer().get(Keys.PART_CLASS, PersistentDataType.STRING), (String)hm.getPersistentDataContainer().get(Keys.PART_TYPE, PersistentDataType.STRING), (String)hm.getPersistentDataContainer().get(Keys.PART_MATERIAL, PersistentDataType.STRING), (String)bm.getPersistentDataContainer().get(Keys.PART_MATERIAL, PersistentDataType.STRING), (String)rm.getPersistentDataContainer().get(Keys.PART_MATERIAL, PersistentDataType.STRING));
        if (toolDefinition.getHeadMaterial().equals("REINFORCED_ALLOY") || toolDefinition.getRodMaterial().equals("HARDENED_METAL") || toolDefinition.getHeadMaterial().equals("INFINITY_SINGULARITY") || toolDefinition.getHeadMaterial().equals("OSMIUM")) {
            switch (toolDefinition.getPartType()) {
                case "SHOVEL": {
                    tool = Guide.EXP_SHOVEL.getStack(toolDefinition);
                    break;
                }
                case "PICK": {
                    tool = Guide.EXP_PICKAXE.getStack(toolDefinition);
                    break;
                }
                case "AXE": {
                    tool = Guide.EXP_AXE.getStack(toolDefinition);
                    break;
                }
                case "HOE": {
                    tool = Guide.EXP_HOE.getStack(toolDefinition);
                    break;
                }
                case "SWORD": {
                    tool = Guide.EXP_SWORD.getStack(toolDefinition);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + toolDefinition.getClassType());
                }
            }
        } else {
            switch (toolDefinition.getPartType()) {
                case "SHOVEL": {
                    tool = Guide.SHOVEL.getStack(toolDefinition);
                    break;
                }
                case "PICK": {
                    tool = Guide.PICKAXE.getStack(toolDefinition);
                    break;
                }
                case "AXE": {
                    tool = Guide.AXE.getStack(toolDefinition);
                    break;
                }
                case "HOE": {
                    tool = Guide.HOE.getStack(toolDefinition);
                    break;
                }
                case "SWORD": {
                    tool = Guide.SWORD.getStack(toolDefinition);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + toolDefinition.getClassType());
                }
            }
        }
        return tool;
    }

    protected boolean validateClass(ItemStack itemStack, String classType) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        if (!itemStack.getItemMeta().getPersistentDataContainer().has(Keys.PART_CLASS, PersistentDataType.STRING)) {
            return false;
        }
        String type = (String)itemStack.getItemMeta().getPersistentDataContainer().get(Keys.PART_CLASS, PersistentDataType.STRING);
        assert (type != null);
        return type.equals(classType);
    }

    protected boolean validateBinder(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        String name = ItemUtils.getItemName(itemStack);
        return name != null && name.startsWith("PART_BINDING_");
    }

    protected void craft(BlockMenu blockMenu, Player player) {
        ItemStack head = blockMenu.getItemInSlot(15);
        ItemStack binding = blockMenu.getItemInSlot(13);
        ItemStack rod = blockMenu.getItemInSlot(11);
        if (head == null || binding == null || rod == null) {
            player.sendMessage(ThemeUtils.ERROR + "Not all items present");
            return;
        }
        if (!(this.validateClass(head, "HEAD") && this.validateBinder(binding) && this.validateClass(rod, "ROD"))) {
            player.sendMessage(ThemeUtils.WARNING + "One or more items are either not Tinker's parts or in the wrong slot?");
            return;
        }
        blockMenu.pushItem(this.getTool(head, binding, rod).clone(), new int[]{42});
        blockMenu.getItemInSlot(15).setAmount(blockMenu.getItemInSlot(15).getAmount() - 1);
        blockMenu.getItemInSlot(13).setAmount(blockMenu.getItemInSlot(13).getAmount() - 1);
        blockMenu.getItemInSlot(11).setAmount(blockMenu.getItemInSlot(11).getAmount() - 1);
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND_SLOTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_INPUT, BACKGROUND_INPUTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_OUTPUT, BACKGROUND_OUTPUT);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_PREVIEW, BACKGROUND_PREVIEW);
        blockMenuPreset.addItem(40, (ItemStack)GUIItems.MENU_CRAFT_TOOL_TABLE);
        blockMenuPreset.addItem(2, (ItemStack)GUIItems.MENU_MARKER_ROD);
        blockMenuPreset.addItem(4, (ItemStack)GUIItems.MENU_MARKER_BINDER);
        blockMenuPreset.addItem(6, (ItemStack)GUIItems.MENU_MARKER_HEAD);
        blockMenuPreset.addItem(38, (ItemStack)GUIItems.MENU_PREVIEW);
        blockMenuPreset.addMenuClickHandler(40, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(2, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(4, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(6, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(38, (player, i, itemStack, clickAction) -> false);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[0];
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent e, @Nonnull BlockMenu menu) {
        super.onBreak(e, menu);
        Location location = menu.getLocation();
        menu.dropItems(location, new int[]{15});
        menu.dropItems(location, new int[]{13});
        menu.dropItems(location, new int[]{11});
        menu.dropItems(location, new int[]{42});
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
        super.onNewInstance(blockMenu, b);
        blockMenu.addMenuClickHandler(40, (player, i, itemStack, clickAction) -> {
            this.craft(blockMenu, player);
            return false;
        });
    }
}

