/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.managers;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;

public class MemoryManager {
    private static MemoryManager instance;
    private final Map<UUID, Long> activeHasteBursts = new HashMap<UUID, Long>();

    public MemoryManager() {
        Preconditions.checkArgument((instance == null ? 1 : 0) != 0, (Object)"Cannot create a new instance of the ListenerManager");
        instance = this;
    }

    public long getHasteBurstEnd(@Nonnull UUID uuid) {
        return this.activeHasteBursts.getOrDefault(uuid, 0L);
    }

    public void setHasteBurstEnd(@Nonnull UUID uuid, long duration) {
        long timeNow = System.currentTimeMillis();
        long endTime = timeNow + duration;
        this.activeHasteBursts.put(uuid, endTime);
    }

    public void removeHasteBurst(@Nonnull UUID uuid) {
        this.activeHasteBursts.remove(uuid);
    }

    public static MemoryManager getInstance() {
        return instance;
    }
}

