/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.listeners;

import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.EntityUtils;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityDamagedListener
implements Listener {
    @EventHandler
    public void onEntityDamaged(EntityDamageByEntityEvent event) {
        if (this.isInvalidEvent(event)) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        EventFriend friend = new EventFriend(player, TraitEventType.ENTITY_DAMAGED);
        friend.setDamagedEntity(event.getEntity());
        friend.setInitialDamage(event.getDamage());
        EventChannels.checkTool(friend);
        EventChannels.checkArmour(friend);
        if (friend.isActionTaken()) {
            int rnd;
            this.modChecks(heldItem, friend);
            if (friend.isCancelEvent()) {
                event.setCancelled(true);
                return;
            }
            EventChannels.settlePotionEffects(friend);
            LivingEntity e = (LivingEntity)friend.getDamagedEntity();
            if (friend.getSegganesson() == 10) {
                event.setDamage(event.getDamage() + friend.getSegganessonDamage());
                friend.setSegganesson(0);
                friend.setSegganessonDamage(0.0);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)50, (int)120, (int)200), 5.0f);
                e.getWorld().spawnParticle(Particle.REDSTONE, e.getLocation(), 50, 1.0, 1.0, 1.0, 0.5, (Object)dustOptions, true);
            }
            if (friend.getCharged() >= 2 && (rnd = ThreadLocalRandom.current().nextInt(1, 6)) == 1) {
                friend.setDamageMod(friend.getDamageMod() * 3.0);
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.YELLOW, 5.0f);
                e.getWorld().spawnParticle(Particle.REDSTONE, e.getLocation(), 50, 1.0, 1.0, 1.0, 0.5, (Object)dustOptions, true);
                PotionEffect potionEffect = new PotionEffect(PotionEffectType.SLOW, 40, 99);
                e.addPotionEffect(potionEffect);
            }
            event.setDamage(friend.getDamageOverride() == null ? event.getDamage() * friend.getDamageMod() : friend.getDamageOverride());
        }
    }

    private void modChecks(ItemStack heldItem, EventFriend friend) {
        Map<String, Integer> modLevels = Modifications.getAllModLevels(heldItem);
        if (modLevels.containsKey(Material.QUARTZ.toString())) {
            this.modCheckQuartz(modLevels.get(Material.QUARTZ.toString()), friend);
        }
    }

    private void modCheckQuartz(int level, @Nonnull EventFriend friend) {
        friend.setDamageMod(friend.getDamageMod() + (double)level * 0.2);
    }

    private boolean isInvalidEvent(@Nonnull EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        return !(event.getDamager() instanceof Player) || event.isCancelled() || !(entity instanceof LivingEntity) || EntityUtils.isTrainingDummy(entity) || EntityUtils.shouldIgnoreDamage(entity);
    }
}

