/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils.datatypes;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public final class DataTypeMethods {
    @Nullable
    public static <T, Z> Z getCustom(@Nonnull PersistentDataHolder holder, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<T, Z> type) {
        return (Z)holder.getPersistentDataContainer().get(key, type);
    }

    @Nonnull
    public static <T, Z> Optional<Z> getOptionalCustom(@Nonnull PersistentDataHolder holder, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<T, Z> type) {
        return Optional.ofNullable(DataTypeMethods.getCustom(holder, key, type));
    }

    public static <T, Z> Z getCustom(@Nonnull PersistentDataHolder holder, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<T, Z> type, @Nonnull Z defaultVal) {
        return (Z)holder.getPersistentDataContainer().getOrDefault(key, type, defaultVal);
    }

    public static <T, Z> boolean hasCustom(@Nonnull PersistentDataHolder holder, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<T, Z> type) {
        return holder.getPersistentDataContainer().has(key, type);
    }

    public static <T, Z> void setCustom(@Nonnull PersistentDataHolder holder, @Nonnull NamespacedKey key, @Nonnull PersistentDataType<T, Z> type, @Nonnull Z obj) {
        holder.getPersistentDataContainer().set(key, type, obj);
    }

    private DataTypeMethods() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

