/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.morepersistentdatatypes.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class DoubleArrayDataType
implements PersistentDataType<byte[], double[]> {
    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<double[]> getComplexType() {
        return double[].class;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte @NotNull [] toPrimitive(double[] doubles, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(doubles.length);
                for (double number : doubles) {
                    dos.writeDouble(number);
                }
                dos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public double @NotNull [] fromPrimitive(byte @NotNull [] bytes, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            double[] dArray;
            try (DataInputStream dis = new DataInputStream(bis);){
                double[] doubles = new double[dis.readInt()];
                for (int i = 0; i < doubles.length; ++i) {
                    doubles[i] = dis.readDouble();
                }
                dArray = doubles;
            }
            return dArray;
        }
    }
}

