/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils.datatypes;

import de.jeff_media.morepersistentdatatypes.DataType;
import io.github.sefiraat.networks.network.stackcaches.BlueprintInstance;
import io.github.sefiraat.networks.utils.Keys;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentCraftingBlueprintType
implements PersistentDataType<PersistentDataContainer, BlueprintInstance> {
    public static final PersistentDataType<PersistentDataContainer, BlueprintInstance> TYPE = new PersistentCraftingBlueprintType();
    public static final NamespacedKey RECIPE = Keys.newKey("recipe");
    public static final NamespacedKey OUTPUT = Keys.newKey("output");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<BlueprintInstance> getComplexType() {
        return BlueprintInstance.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull BlueprintInstance complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(RECIPE, DataType.ITEM_STACK_ARRAY, (Object)complex.getRecipeItems());
        container.set(OUTPUT, DataType.ITEM_STACK, (Object)complex.getItemStack());
        return container;
    }

    @Nonnull
    public BlueprintInstance fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        ItemStack[] recipe = (ItemStack[])primitive.get(RECIPE, DataType.ITEM_STACK_ARRAY);
        ItemStack output = (ItemStack)primitive.get(OUTPUT, DataType.ITEM_STACK);
        return new BlueprintInstance(recipe, output);
    }
}

