/*
 * Decompiled with CFR 0.152.
 */
package de.jeff_media.morepersistentdatatypes.implementation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.charset.Charset;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class FloatArrayDataType
implements PersistentDataType<byte[], float[]> {
    private Charset charset;

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<float[]> getComplexType() {
        return float[].class;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte @NotNull [] toPrimitive(float[] floats, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(floats.length);
                for (float number : floats) {
                    dos.writeFloat(number);
                }
                dos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public float @NotNull [] fromPrimitive(byte @NotNull [] bytes, @NotNull PersistentDataAdapterContext itemTagAdapterContext) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            float[] fArray;
            try (DataInputStream dis = new DataInputStream(bis);){
                float[] floats = new float[dis.readInt()];
                for (int i = 0; i < floats.length; ++i) {
                    floats[i] = dis.readFloat();
                }
                fArray = floats;
            }
            return fArray;
        }
    }
}

