/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.utils;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public final class StringUtils {
    @Nonnull
    private static final List<String> EGG_NAMES = Arrays.asList("TheBusyBiscuit", "Alessio", "Walshy", "Jeff", "Seggan", "BOOMER_1", "svr333", "variananora", "ProfElements", "Riley", "FluffyBear", "GallowsDove", "Apeiros", "Martin", "Bunnky", "ReasonFoundDecoy", "Oah", "Azak", "andrewandy", "EpicPlayer10", "GentlemanCheesy", "ybw0014", "Ashian", "R.I.P", "OOOOMAGAAA", "TerslenK", "FN_FAL", "supertechxter");

    private StringUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    public static String toTitleCase(@Nonnull String string) {
        return StringUtils.toTitleCase(string, true);
    }

    @Nonnull
    public static String toTitleCase(@Nonnull String string, boolean delimiterToSpace) {
        return StringUtils.toTitleCase(string, delimiterToSpace, " _'-/");
    }

    @Nonnull
    public static String toTitleCase(@Nonnull String string, boolean delimiterToSpace, @Nonnull String delimiters) {
        StringBuilder builder = new StringBuilder();
        boolean capNext = true;
        for (char character : string.toCharArray()) {
            character = capNext ? Character.toUpperCase(character) : Character.toLowerCase(character);
            builder.append(character);
            capNext = delimiters.indexOf(character) >= 0;
        }
        String built = builder.toString();
        if (delimiterToSpace) {
            int space = 32;
            for (char c : delimiters.toCharArray()) {
                built = built.replace(c, ' ');
            }
        }
        return built;
    }

    @Nonnull
    public static String getRandomEggName() {
        int rnd = ThreadLocalRandom.current().nextInt(0, EGG_NAMES.size());
        return EGG_NAMES.get(rnd);
    }

    @Nonnull
    public static List<String> getEggNames() {
        return EGG_NAMES;
    }
}

