/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network.barrel;

import io.github.sefiraat.networks.network.barrel.BarrelType;
import io.github.sefiraat.networks.network.stackcaches.BarrelIdentity;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.network.stackcaches.QuantumCache;
import io.github.sefiraat.networks.slimefun.network.NetworkQuantumStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class NetworkStorage
extends BarrelIdentity {
    public NetworkStorage(Location location, ItemStack itemStack, int amount) {
        super(location, itemStack, amount, BarrelType.NETWORKS);
    }

    @Override
    @Nullable
    public ItemStack requestItem(@Nonnull ItemRequest itemRequest) {
        BlockMenu blockMenu = BlockStorage.getInventory((Location)this.getLocation());
        if (blockMenu == null) {
            return null;
        }
        QuantumCache cache = NetworkQuantumStorage.getCaches().get(blockMenu.getLocation());
        if (cache == null) {
            return null;
        }
        return NetworkQuantumStorage.getItemStack(cache, blockMenu, itemRequest.getAmount());
    }

    @Override
    public void depositItemStack(ItemStack[] itemsToDeposit) {
        if (BlockStorage.check((Location)this.getLocation()) instanceof NetworkQuantumStorage) {
            BlockMenu blockMenu = BlockStorage.getInventory((Location)this.getLocation());
            QuantumCache cache = NetworkQuantumStorage.getCaches().get(this.getLocation());
            if (cache != null) {
                NetworkQuantumStorage.tryInputItem(blockMenu.getLocation(), itemsToDeposit, cache);
            }
        }
    }

    @Override
    public int getInputSlot() {
        return 1;
    }

    @Override
    public int getOutputSlot() {
        return 7;
    }
}

