/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network;

import io.github.sefiraat.networks.utils.StackUtils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.SlimefunBackpack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

public final class SupportedRecipes {
    private static final Map<ItemStack[], ItemStack> RECIPES = new HashMap<ItemStack[], ItemStack>();

    public static Map<ItemStack[], ItemStack> getRecipes() {
        return RECIPES;
    }

    public static void addRecipe(@Nonnull ItemStack[] input, @Nonnull ItemStack output) {
        RECIPES.put(input, output);
    }

    public static boolean testRecipe(@Nonnull ItemStack[] input, @Nonnull ItemStack[] recipe) {
        for (int test = 0; test < recipe.length; ++test) {
            if (StackUtils.itemsMatch(input[test], recipe[test])) continue;
            return false;
        }
        return true;
    }

    public static boolean allowedRecipe(@Nonnull SlimefunItem item) {
        return !(item instanceof SlimefunBackpack);
    }

    private SupportedRecipes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            RecipeType recipeType = item.getRecipeType();
            if (recipeType != RecipeType.ENHANCED_CRAFTING_TABLE || !SupportedRecipes.allowedRecipe(item)) continue;
            ItemStack[] itemStacks = new ItemStack[9];
            int i = 0;
            for (ItemStack itemStack : item.getRecipe()) {
                itemStacks[i] = itemStack == null ? null : new ItemStack(itemStack.clone());
                ++i;
            }
            SupportedRecipes.addRecipe(itemStacks, item.getRecipeOutput());
        }
    }
}

