/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.network.stackcaches.ItemRequest;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.slimefun.network.NetworkWirelessReceiver;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class NetworkWirelessTransmitter
extends NetworkObject {
    public static final int TEMPLATE_SLOT = 13;
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int[] BACKGROUND_SLOTS_TEMPLATE = new int[]{3, 4, 5, 12, 14, 21, 22, 23};
    private static final CustomItemStack TEMPLATE_BACKGROUND_STACK = new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.SUCCESS + "Transmit items matching", new String[0]);
    private static final String LINKED_LOCATION_KEY_X = "linked-location-x";
    private static final String LINKED_LOCATION_KEY_Y = "linked-location-y";
    private static final String LINKED_LOCATION_KEY_Z = "linked-location-z";
    private static final int REQUIRED_POWER = 500;
    private static final int TICKS_PER = 2;
    private final Map<Location, Location> linkedLocations = new HashMap<Location, Location>();

    public NetworkWirelessTransmitter(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.WIRELESS_TRANSMITTER);
        this.getSlotsToDrop().add(13);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){
            private final Map<Location, Integer> tickMap = new HashMap<Location, Integer>();
            private final Map<Location, Boolean> firstTick = new HashMap<Location, Boolean>();

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                if (blockMenu != null) {
                    int tick;
                    NetworkWirelessTransmitter.this.addToRegistry(block);
                    boolean isFirstTick = this.firstTick.getOrDefault(block.getLocation(), true);
                    if (isFirstTick) {
                        String xString = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)NetworkWirelessTransmitter.LINKED_LOCATION_KEY_X);
                        String yString = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)NetworkWirelessTransmitter.LINKED_LOCATION_KEY_Y);
                        String zString = BlockStorage.getLocationInfo((Location)block.getLocation(), (String)NetworkWirelessTransmitter.LINKED_LOCATION_KEY_Z);
                        if (xString != null && yString != null && zString != null) {
                            Location linkedLocation = new Location(block.getWorld(), (double)Integer.parseInt(xString), (double)Integer.parseInt(yString), (double)Integer.parseInt(zString));
                            NetworkWirelessTransmitter.this.linkedLocations.put(block.getLocation(), linkedLocation);
                        }
                        this.firstTick.put(block.getLocation(), false);
                    }
                    if ((tick = this.tickMap.getOrDefault(block.getLocation(), 0).intValue()) >= 2) {
                        NetworkWirelessTransmitter.this.onTick(blockMenu);
                        this.tickMap.remove(block.getLocation());
                        tick = 0;
                    } else {
                        ++tick;
                    }
                    this.tickMap.put(block.getLocation(), tick + 1);
                }
            }
        }});
    }

    private void onTick(@Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        Location location = blockMenu.getLocation();
        Location linkedLocation = this.linkedLocations.get(location);
        if (linkedLocation == null) {
            return;
        }
        SlimefunItem slimefunItem = BlockStorage.check((Location)linkedLocation);
        if (!(slimefunItem instanceof NetworkWirelessReceiver)) {
            this.linkedLocations.remove(location);
            return;
        }
        BlockMenu linkedBlockMenu = BlockStorage.getInventory((Location)linkedLocation);
        ItemStack itemStack = linkedBlockMenu.getItemInSlot(13);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            ItemStack templateStack = blockMenu.getItemInSlot(13);
            if (templateStack == null || templateStack.getType() == Material.AIR) {
                return;
            }
            if (definition.getNode().getRoot().getRootPower() < 500L) {
                return;
            }
            ItemStack stackToPush = definition.getNode().getRoot().getItemStack(new ItemRequest(templateStack.clone(), templateStack.getMaxStackSize()));
            if (stackToPush != null) {
                definition.getNode().getRoot().removeRootPower(500L);
                linkedBlockMenu.pushItem(stackToPush, new int[]{13});
                if (definition.getNode().getRoot().isDisplayParticles()) {
                    Location particleLocation = blockMenu.getLocation().clone().add(0.5, 1.1, 0.5);
                    Location particleLocation2 = linkedBlockMenu.getLocation().clone().add(0.5, 2.1, 0.5);
                    particleLocation.getWorld().spawnParticle(Particle.WAX_ON, particleLocation, 0, 0.0, 4.0, 0.0);
                    particleLocation2.getWorld().spawnParticle(Particle.WAX_OFF, particleLocation2, 0, 0.0, -4.0, 0.0);
                }
            }
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.drawBackground((ItemStack)TEMPLATE_BACKGROUND_STACK, BACKGROUND_SLOTS_TEMPLATE);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_CELL.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[]{0};
            }
        };
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent event) {
        super.onBreak(event);
        this.linkedLocations.remove(event.getBlock().getLocation());
    }

    public void addLinkedLocation(@Nonnull Block block, @Nonnull Location linkedLocation) {
        this.linkedLocations.put(block.getLocation(), linkedLocation);
        BlockStorage.addBlockInfo((Block)block, (String)LINKED_LOCATION_KEY_X, (String)String.valueOf(linkedLocation.getBlockX()));
        BlockStorage.addBlockInfo((Block)block, (String)LINKED_LOCATION_KEY_Y, (String)String.valueOf(linkedLocation.getBlockY()));
        BlockStorage.addBlockInfo((Block)block, (String)LINKED_LOCATION_KEY_Z, (String)String.valueOf(linkedLocation.getBlockZ()));
    }
}

