/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import com.bgsoftware.wildchests.api.WildChestsAPI;
import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.Networks;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkDirectional;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class NetworkVanillaGrabber
extends NetworkDirectional {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 16, 17, 18, 20, 22, 23, 24, 26, 27, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int OUTPUT_SLOT = 25;
    private static final int NORTH_SLOT = 11;
    private static final int SOUTH_SLOT = 29;
    private static final int EAST_SLOT = 21;
    private static final int WEST_SLOT = 19;
    private static final int UP_SLOT = 14;
    private static final int DOWN_SLOT = 32;

    public NetworkVanillaGrabber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.PUSHER);
        this.getSlotsToDrop().add(25);
    }

    @Override
    protected void onTick(@Nullable BlockMenu blockMenu, @Nonnull Block block) {
        super.onTick(blockMenu, block);
        if (blockMenu != null) {
            this.tryGrabItem(blockMenu);
        }
    }

    private void tryGrabItem(@Nonnull BlockMenu blockMenu) {
        block10: {
            ItemStack[] furnaceInventoryResult;
            ItemStack[] inventory;
            block9: {
                ItemStack itemInSlot = blockMenu.getItemInSlot(25);
                if (itemInSlot != null && itemInSlot.getType() != Material.AIR) {
                    return;
                }
                NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
                if (definition == null || definition.getNode() == null) {
                    return;
                }
                BlockFace direction = this.getCurrentDirection(blockMenu);
                Block block = blockMenu.getBlock();
                Block targetBlock = block.getRelative(direction);
                UUID uuid = UUID.fromString(BlockStorage.getLocationInfo((Location)block.getLocation(), (String)"uuid"));
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!Slimefun.getProtectionManager().hasPermission(offlinePlayer, targetBlock, Interaction.INTERACT_BLOCK)) {
                    return;
                }
                BlockState blockState = targetBlock.getState();
                BlockState blockState2 = blockState;
                if (!(blockState2 instanceof InventoryHolder)) {
                    return;
                }
                InventoryHolder holder = (InventoryHolder)blockState2;
                boolean wildChests = Networks.getSupportedPluginManager().isWildChests();
                boolean isChest = wildChests && WildChestsAPI.getChest((Location)targetBlock.getLocation()) != null;
                this.sendDebugMessage(block.getLocation(), "WildChests detected: " + wildChests);
                this.sendDebugMessage(block.getLocation(), "Block detected as chest: " + isChest);
                if (wildChests && isChest) {
                    this.sendDebugMessage(block.getLocation(), "WildChest test failed, escaping");
                    return;
                }
                this.sendDebugMessage(block.getLocation(), "WildChest test passed.");
                ItemStack[] itemStackArray = inventory = holder.getInventory();
                if (!(itemStackArray instanceof FurnaceInventory)) break block9;
                FurnaceInventory furnaceInventory = (FurnaceInventory)itemStackArray;
                furnaceInventoryResult = furnaceInventory.getResult();
                ItemStack furnaceInventoryFuel = furnaceInventory.getFuel();
                this.grabItem(blockMenu, (ItemStack)furnaceInventoryResult);
                if (furnaceInventoryFuel == null || furnaceInventoryFuel.getType() != Material.BUCKET) break block10;
                this.grabItem(blockMenu, furnaceInventoryFuel);
                break block10;
            }
            furnaceInventoryResult = inventory;
            if (furnaceInventoryResult instanceof BrewerInventory) {
                BrewerInventory brewerInventory = (BrewerInventory)furnaceInventoryResult;
                for (int i = 0; i < 3; ++i) {
                    PotionMeta potionMeta;
                    ItemStack stack = brewerInventory.getContents()[i];
                    if (stack == null || stack.getType() != Material.POTION || (potionMeta = (PotionMeta)stack.getItemMeta()).getBasePotionData().getType() == PotionType.WATER) continue;
                    this.grabItem(blockMenu, stack);
                    return;
                }
            } else {
                for (ItemStack stack : inventory.getContents()) {
                    if (!this.grabItem(blockMenu, stack)) continue;
                    return;
                }
            }
        }
    }

    private boolean grabItem(@Nonnull BlockMenu blockMenu, @Nullable ItemStack stack) {
        if (stack != null && stack.getType() != Material.AIR) {
            blockMenu.replaceExistingItem(25, stack.clone());
            stack.setAmount(0);
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    protected int[] getBackgroundSlots() {
        return BACKGROUND_SLOTS;
    }

    @Override
    public int getNorthSlot() {
        return 11;
    }

    @Override
    public int getSouthSlot() {
        return 29;
    }

    @Override
    public int getEastSlot() {
        return 21;
    }

    @Override
    public int getWestSlot() {
        return 19;
    }

    @Override
    public int getUpSlot() {
        return 14;
    }

    @Override
    public int getDownSlot() {
        return 32;
    }

    @Override
    public boolean runSync() {
        return true;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{25};
    }

    @Override
    protected Particle.DustOptions getDustOptions() {
        return new Particle.DustOptions(Color.MAROON, 1.0f);
    }
}

