/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.network.SupportedRecipes;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.slimefun.tools.CraftingBlueprint;
import io.github.sefiraat.networks.utils.StackUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkEncoder
extends NetworkObject {
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 15, 17, 18, 20, 24, 25, 26, 27, 28, 29, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] RECIPE_SLOTS = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
    private static final int[] BLUEPRINT_BACK = new int[]{10, 28};
    private static final int BLANK_BLUEPRINT_SLOT = 19;
    private static final int ENCODE_SLOT = 16;
    private static final int OUTPUT_SLOT = 34;
    private static final int CHARGE_COST = 20000;
    public static final CustomItemStack BLUEPRINT_BACK_STACK = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, Theme.PASSIVE + "Blank Blueprint", new String[0]);
    public static final CustomItemStack ENCODE_STACK = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, Theme.PASSIVE + "Click to encode when valid", new String[0]);

    public NetworkEncoder(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.ENCODER);
        for (int recipeSlot : RECIPE_SLOTS) {
            this.getSlotsToDrop().add(recipeSlot);
        }
        this.getSlotsToDrop().add(19);
        this.getSlotsToDrop().add(34);
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND);
                this.drawBackground((ItemStack)BLUEPRINT_BACK_STACK, BLUEPRINT_BACK);
                this.addItem(16, (ItemStack)ENCODE_STACK, (player, i, itemStack, clickAction) -> false);
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                menu.addMenuClickHandler(16, (player, i, itemStack, clickAction) -> {
                    NetworkEncoder.this.tryEncode(player, menu);
                    return false;
                });
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_RECIPE_ENCODER.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
    }

    public void tryEncode(@Nonnull Player player, @Nonnull BlockMenu blockMenu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
        if (definition == null || definition.getNode() == null) {
            return;
        }
        NetworkRoot root = definition.getNode().getRoot();
        long networkCharge = root.getRootPower();
        if (networkCharge < 20000L) {
            player.sendMessage(Theme.WARNING + "Not enough Network power to fulfill this task.");
            return;
        }
        ItemStack outputStack = blockMenu.getItemInSlot(34);
        if (outputStack != null && outputStack.getType() != Material.AIR) {
            player.sendMessage(Theme.WARNING + "The output slot must be empty.");
            return;
        }
        ItemStack blueprint = blockMenu.getItemInSlot(19);
        if (!(SlimefunItem.getByItem((ItemStack)blueprint) instanceof CraftingBlueprint)) {
            player.sendMessage(Theme.WARNING + "You need to provide a blank blueprint");
            return;
        }
        ItemStack[] inputs = new ItemStack[RECIPE_SLOTS.length];
        int i = 0;
        for (int recipeSlot : RECIPE_SLOTS) {
            ItemStack stackInSlot = blockMenu.getItemInSlot(recipeSlot);
            if (stackInSlot != null) {
                inputs[i] = new ItemStack(stackInSlot);
                inputs[i].setAmount(1);
            }
            ++i;
        }
        ItemStack crafted = null;
        for (Map.Entry<ItemStack[], ItemStack> entry : SupportedRecipes.getRecipes().entrySet()) {
            if (!SupportedRecipes.testRecipe(inputs, entry.getKey())) continue;
            crafted = new ItemStack(entry.getValue().clone());
            break;
        }
        if (crafted == null) {
            crafted = Bukkit.craftItem((ItemStack[])((ItemStack[])inputs.clone()), (World)player.getWorld(), (Player)player);
        }
        if (crafted.getType() == Material.AIR) {
            player.sendMessage(Theme.WARNING + "Doesn't look like this is a valid recipe.");
            return;
        }
        ItemStack blueprintClone = StackUtils.getAsQuantity(blueprint, 1);
        blueprint.setAmount(blueprint.getAmount() - 1);
        CraftingBlueprint.setBlueprint(blueprintClone, inputs, crafted);
        for (int recipeSlot : RECIPE_SLOTS) {
            ItemStack slotItem = blockMenu.getItemInSlot(recipeSlot);
            if (slotItem == null) continue;
            slotItem.setAmount(slotItem.getAmount() - 1);
        }
        blockMenu.pushItem(blueprintClone, new int[]{34});
        root.removeRootPower(20000L);
    }
}

