/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.utils.NetworkUtils;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public abstract class NetworkDirectional
extends NetworkObject {
    private static final int NORTH_SLOT = 12;
    private static final int SOUTH_SLOT = 30;
    private static final int EAST_SLOT = 22;
    private static final int WEST_SLOT = 20;
    private static final int UP_SLOT = 15;
    private static final int DOWN_SLOT = 33;
    protected static final String DIRECTION = "direction";
    protected static final String OWNER_KEY = "uuid";
    private static final Set<BlockFace> VALID_FACES = EnumSet.of(BlockFace.UP, new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST});
    private static final Map<Location, BlockFace> SELECTED_DIRECTION_MAP = new HashMap<Location, BlockFace>();
    private final ItemSetting<Integer> tickRate = new IntRangeSetting((SlimefunItem)this, "tick_rate", 1, 1, 10);

    protected NetworkDirectional(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, NodeType type) {
        super(itemGroup, item, recipeType, recipe, type);
        this.addItemSetting(new ItemSetting[]{this.tickRate});
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                NetworkStorage.removeNode(event.getBlock().getLocation());
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)NetworkDirectional.OWNER_KEY, (String)event.getPlayer().getUniqueId().toString());
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)NetworkDirectional.DIRECTION, (String)BlockFace.SELF.name());
                NetworkUtils.applyConfig(NetworkDirectional.this, BlockStorage.getInventory((Block)event.getBlock()), event.getPlayer());
            }
        }, new BlockTicker(){
            private int tick = 1;

            public boolean isSynchronized() {
                return NetworkDirectional.this.runSync();
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                if (this.tick <= 1) {
                    BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                    NetworkDirectional.this.onTick(blockMenu, block);
                }
            }

            public void uniqueTick() {
                int n = this.tick = this.tick <= 1 ? (Integer)NetworkDirectional.this.tickRate.getValue() : this.tick - 1;
                if (this.tick <= 1) {
                    NetworkDirectional.this.onUniqueTick();
                }
            }
        }});
    }

    private void updateGui(@Nullable BlockMenu blockMenu) {
        if (blockMenu == null || !blockMenu.hasViewer()) {
            return;
        }
        BlockFace direction = this.getCurrentDirection(blockMenu);
        block16: for (BlockFace blockFace : VALID_FACES) {
            Block block = blockMenu.getBlock().getRelative(blockFace);
            SlimefunItem slimefunItem = BlockStorage.check((Block)block);
            if (slimefunItem != null) {
                switch (blockFace) {
                    case NORTH: {
                        blockMenu.replaceExistingItem(this.getNorthSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                    case SOUTH: {
                        blockMenu.replaceExistingItem(this.getSouthSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                    case EAST: {
                        blockMenu.replaceExistingItem(this.getEastSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                    case WEST: {
                        blockMenu.replaceExistingItem(this.getWestSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                    case UP: {
                        blockMenu.replaceExistingItem(this.getUpSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                    case DOWN: {
                        blockMenu.replaceExistingItem(this.getDownSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, slimefunItem, blockFace == direction));
                        continue block16;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + blockFace);
            }
            Material material = block.getType();
            switch (blockFace) {
                case NORTH: {
                    blockMenu.replaceExistingItem(this.getNorthSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
                case SOUTH: {
                    blockMenu.replaceExistingItem(this.getSouthSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
                case EAST: {
                    blockMenu.replaceExistingItem(this.getEastSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
                case WEST: {
                    blockMenu.replaceExistingItem(this.getWestSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
                case UP: {
                    blockMenu.replaceExistingItem(this.getUpSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
                case DOWN: {
                    blockMenu.replaceExistingItem(this.getDownSlot(), NetworkDirectional.getDirectionalSlotPane(blockFace, material, blockFace == direction));
                    continue block16;
                }
            }
            throw new IllegalStateException("Unexpected value: " + blockFace);
        }
    }

    @Nonnull
    protected BlockFace getCurrentDirection(@Nonnull BlockMenu blockMenu) {
        BlockFace direction = SELECTED_DIRECTION_MAP.get(blockMenu.getLocation().clone());
        if (direction == null) {
            direction = BlockFace.valueOf((String)BlockStorage.getLocationInfo((Location)blockMenu.getLocation(), (String)DIRECTION));
            SELECTED_DIRECTION_MAP.put(blockMenu.getLocation().clone(), direction);
        }
        return direction;
    }

    @OverridingMethodsMustInvokeSuper
    protected void onTick(@Nullable BlockMenu blockMenu, @Nonnull Block block) {
        this.addToRegistry(block);
        this.updateGui(blockMenu);
    }

    protected void onUniqueTick() {
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(NetworkDirectional.this.getBackgroundSlots());
                if (NetworkDirectional.this.getOtherBackgroundSlots() != null && NetworkDirectional.this.getOtherBackgroundStack() != null) {
                    this.drawBackground((ItemStack)NetworkDirectional.this.getOtherBackgroundStack(), NetworkDirectional.this.getOtherBackgroundSlots());
                }
                this.addItem(NetworkDirectional.this.getNorthSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.NORTH, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
                this.addItem(NetworkDirectional.this.getSouthSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.SOUTH, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
                this.addItem(NetworkDirectional.this.getEastSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.EAST, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
                this.addItem(NetworkDirectional.this.getWestSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.WEST, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
                this.addItem(NetworkDirectional.this.getUpSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.UP, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
                this.addItem(NetworkDirectional.this.getDownSlot(), NetworkDirectional.getDirectionalSlotPane(BlockFace.DOWN, Material.AIR, false), (player, i, itemStack, clickAction) -> false);
            }

            public void newInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
                BlockFace direction;
                String string = BlockStorage.getLocationInfo((Location)blockMenu.getLocation(), (String)NetworkDirectional.DIRECTION);
                if (string == null) {
                    direction = BlockFace.SELF;
                    BlockStorage.addBlockInfo((Location)blockMenu.getLocation(), (String)NetworkDirectional.DIRECTION, (String)BlockFace.SELF.name());
                } else {
                    direction = BlockFace.valueOf((String)string);
                }
                SELECTED_DIRECTION_MAP.put(blockMenu.getLocation().clone(), direction);
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getNorthSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.NORTH));
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getSouthSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.SOUTH));
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getEastSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.EAST));
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getWestSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.WEST));
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getUpSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.UP));
                blockMenu.addMenuClickHandler(NetworkDirectional.this.getDownSlot(), (player, i, itemStack, clickAction) -> NetworkDirectional.this.directionClick(player, clickAction, blockMenu, BlockFace.DOWN));
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return this.getSlimefunItem().canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return NetworkDirectional.this.getInputSlots();
                }
                return NetworkDirectional.this.getOutputSlots();
            }
        };
    }

    @ParametersAreNonnullByDefault
    public boolean directionClick(Player player, ClickAction action, BlockMenu blockMenu, BlockFace blockFace) {
        if (action.isShiftClicked()) {
            this.openDirection(player, blockMenu, blockFace);
        } else {
            this.setDirection(blockMenu, blockFace);
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void openDirection(Player player, BlockMenu blockMenu, BlockFace blockFace) {
        Location location;
        SlimefunItem item;
        BlockMenu targetMenu = BlockStorage.getInventory((Block)blockMenu.getBlock().getRelative(blockFace));
        if (targetMenu != null && (item = BlockStorage.check((Location)(location = targetMenu.getLocation()))).canUse(player, true) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, blockMenu.getLocation(), Interaction.INTERACT_BLOCK)) {
            targetMenu.open(new Player[]{player});
        }
    }

    @ParametersAreNonnullByDefault
    public void setDirection(BlockMenu blockMenu, BlockFace blockFace) {
        SELECTED_DIRECTION_MAP.put(blockMenu.getLocation().clone(), blockFace);
        BlockStorage.addBlockInfo((Block)blockMenu.getBlock(), (String)DIRECTION, (String)blockFace.name());
    }

    @Nonnull
    protected int[] getBackgroundSlots() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 16, 17, 18, 19, 21, 23, 24, 25, 26, 27, 28, 29, 21, 31, 32, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    }

    @Nullable
    protected int[] getOtherBackgroundSlots() {
        return null;
    }

    @Nullable
    protected CustomItemStack getOtherBackgroundStack() {
        return null;
    }

    public int getNorthSlot() {
        return 12;
    }

    public int getSouthSlot() {
        return 30;
    }

    public int getEastSlot() {
        return 22;
    }

    public int getWestSlot() {
        return 20;
    }

    public int getUpSlot() {
        return 15;
    }

    public int getDownSlot() {
        return 33;
    }

    public int[] getItemSlots() {
        return new int[0];
    }

    public int[] getInputSlots() {
        return new int[0];
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    @Nonnull
    public static ItemStack getDirectionalSlotPane(@Nonnull BlockFace blockFace, @Nonnull SlimefunItem slimefunItem, boolean active) {
        CustomItemStack displayStack = new CustomItemStack(slimefunItem.getItem(), Theme.PASSIVE + "Direction " + blockFace.name() + " (" + ChatColor.stripColor((String)slimefunItem.getItemName()) + ")", new String[0]);
        ItemMeta itemMeta = displayStack.getItemMeta();
        if (active) {
            itemMeta.addEnchant(Enchantment.LUCK, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        itemMeta.setLore(List.of(Theme.CLICK_INFO + "Left Click: " + Theme.PASSIVE + "Set Direction", Theme.CLICK_INFO + "Shift Left Click: " + Theme.PASSIVE + "Open Target Block"));
        displayStack.setItemMeta(itemMeta);
        return displayStack;
    }

    @Nonnull
    public static ItemStack getDirectionalSlotPane(@Nonnull BlockFace blockFace, @Nonnull Material blockMaterial, boolean active) {
        if (blockMaterial.isItem() && !blockMaterial.isAir()) {
            CustomItemStack displayStack = new CustomItemStack(blockMaterial, Theme.PASSIVE + "Direction " + blockFace.name() + " (" + blockMaterial.name() + ")", new String[0]);
            ItemMeta itemMeta = displayStack.getItemMeta();
            if (active) {
                itemMeta.addEnchant(Enchantment.LUCK, 1, true);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            itemMeta.setLore(List.of(Theme.CLICK_INFO + "Left Click: " + Theme.PASSIVE + "Set Direction", Theme.CLICK_INFO + "Shift Left Click: " + Theme.PASSIVE + "Open Target Block"));
            displayStack.setItemMeta(itemMeta);
            return displayStack;
        }
        Material material = active ? Material.GREEN_STAINED_GLASS_PANE : Material.RED_STAINED_GLASS_PANE;
        return new CustomItemStack(material, ChatColor.GRAY + "Set direction: " + blockFace.name(), new String[0]);
    }

    @Nullable
    public static BlockFace getSelectedFace(@Nonnull Location location) {
        return SELECTED_DIRECTION_MAP.get(location);
    }

    protected Particle.DustOptions getDustOptions() {
        return new Particle.DustOptions(Color.RED, 1.0f);
    }

    protected void showParticle(@Nonnull Location location, @Nonnull BlockFace blockFace) {
        Vector faceVector = blockFace.getDirection().clone().multiply(-1);
        Vector pushVector = faceVector.clone().multiply(2);
        Location displayLocation = location.clone().add(0.5, 0.5, 0.5).add(faceVector);
        location.getWorld().spawnParticle(Particle.REDSTONE, displayLocation, 0, pushVector.getX(), pushVector.getY(), pushVector.getZ(), (Object)this.getDustOptions());
    }
}

