/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.groups;

import io.github.sefiraat.networks.slimefun.NetworksItemGroups;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MainFlexGroup
extends FlexItemGroup {
    private static final ItemStack DOCS_ITEM_STACK = Theme.themedItemStack(Material.BOOK, Theme.GUIDE, "Documentation Wiki", "Click to get the link to the", "documentation Wiki for Networks", "and other Sefiraat addons.");
    private static final int GUIDE_BACK = 1;
    private static final int DOCS = 9;
    private static final int MATERIALS = 10;
    private static final int TOOLS = 11;
    private static final int NETWORK_ITEMS = 12;
    private static final int NETWORK_QUANTUMS = 13;
    private static final int[] HEADER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] FOOTER = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};

    public MainFlexGroup(NamespacedKey key, ItemStack item) {
        super(key, item);
    }

    @ParametersAreNonnullByDefault
    public boolean isVisible(Player player, PlayerProfile playerProfile, SlimefunGuideMode guideMode) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void open(Player p, PlayerProfile profile, SlimefunGuideMode mode) {
        ChestMenu chestMenu = new ChestMenu(Theme.MAIN.getColor() + "Networks");
        for (int slot : HEADER) {
            chestMenu.addItem(slot, ChestMenuUtils.getBackground(), (player1, i1, itemStack, clickAction) -> false);
        }
        for (int slot : FOOTER) {
            chestMenu.addItem(slot, ChestMenuUtils.getBackground(), (player1, i1, itemStack, clickAction) -> false);
        }
        chestMenu.setEmptySlotsClickable(false);
        this.setupPage(p, profile, mode, chestMenu);
        chestMenu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private void setupPage(Player player, PlayerProfile profile, SlimefunGuideMode mode, ChestMenu menu) {
        for (int slot2 : FOOTER) {
            menu.replaceExistingItem(slot2, ChestMenuUtils.getBackground());
            menu.addMenuClickHandler(slot2, (player1, i, itemStack, clickAction) -> false);
        }
        menu.replaceExistingItem(1, ChestMenuUtils.getBackButton((Player)player, (String[])new String[]{Slimefun.getLocalization().getMessage("guide.back.guide")}));
        menu.addMenuClickHandler(1, (player1, slot, itemStack, clickAction) -> {
            SlimefunGuide.openMainMenu((PlayerProfile)profile, (SlimefunGuideMode)mode, (int)1);
            return false;
        });
        menu.replaceExistingItem(9, DOCS_ITEM_STACK);
        menu.addMenuClickHandler(9, (player1, i1, itemStack1, clickAction) -> {
            TextComponent link = new TextComponent("To access the documentation Wiki, please click here");
            link.setColor(ChatColor.YELLOW);
            link.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://sefiraat.dev/"));
            player.spigot().sendMessage((BaseComponent)link);
            return false;
        });
        menu.replaceExistingItem(10, NetworksItemGroups.MATERIALS.getItem(player));
        menu.addMenuClickHandler(10, (player1, i1, itemStack1, clickAction) -> this.openPage(profile, NetworksItemGroups.MATERIALS, mode, 1));
        menu.replaceExistingItem(11, NetworksItemGroups.TOOLS.getItem(player));
        menu.addMenuClickHandler(11, (player1, i1, itemStack1, clickAction) -> this.openPage(profile, NetworksItemGroups.TOOLS, mode, 1));
        menu.replaceExistingItem(12, NetworksItemGroups.NETWORK_ITEMS.getItem(player));
        menu.addMenuClickHandler(12, (player1, i1, itemStack1, clickAction) -> this.openPage(profile, NetworksItemGroups.NETWORK_ITEMS, mode, 1));
        menu.replaceExistingItem(13, NetworksItemGroups.NETWORK_QUANTUMS.getItem(player));
        menu.addMenuClickHandler(13, (player1, i1, itemStack1, clickAction) -> this.openPage(profile, NetworksItemGroups.NETWORK_QUANTUMS, mode, 1));
    }

    @ParametersAreNonnullByDefault
    public boolean openPage(PlayerProfile profile, ItemGroup itemGroup, SlimefunGuideMode mode, int page) {
        profile.getGuideHistory().add((ItemGroup)this, 1);
        SlimefunGuide.openItemGroup((PlayerProfile)profile, (ItemGroup)itemGroup, (SlimefunGuideMode)mode, (int)page);
        return false;
    }
}

