/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network;

import io.github.sefiraat.networks.network.NetworkNode;
import io.github.sefiraat.networks.network.NodeType;

public class NodeDefinition {
    private final NodeType type;
    private final long timeRegistered;
    private NetworkNode node;
    private final int charge;

    public NodeDefinition(NodeType type) {
        this(type, 0);
    }

    public NodeDefinition(NodeType type, int charge) {
        this.type = type;
        this.timeRegistered = System.currentTimeMillis();
        this.charge = charge;
    }

    public NodeType getType() {
        return this.type;
    }

    public NetworkNode getNode() {
        return this.node;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setNode(NetworkNode node) {
        this.node = node;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.timeRegistered + 3000L;
    }
}

