/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks;

import io.github.sefiraat.networks.bstats.bukkit.Metrics;
import io.github.sefiraat.networks.bstats.charts.AdvancedPie;
import io.github.sefiraat.networks.commands.NetworksMain;
import io.github.sefiraat.networks.managers.ListenerManager;
import io.github.sefiraat.networks.managers.SupportedPluginManager;
import io.github.sefiraat.networks.slimefun.NetheoPlants;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkController;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Networks
extends JavaPlugin
implements SlimefunAddon {
    private static Networks instance;
    private final String username;
    private final String repo;
    private final String branch;
    private ListenerManager listenerManager;
    private SupportedPluginManager supportedPluginManager;

    public Networks() {
        this.username = "Sefiraat";
        this.repo = "Networks";
        this.branch = "master";
    }

    public void onEnable() {
        instance = this;
        this.getLogger().info("########################################");
        this.getLogger().info("         Networks - By Sefiraat         ");
        this.getLogger().info("########################################");
        this.saveDefaultConfig();
        this.tryUpdate();
        this.supportedPluginManager = new SupportedPluginManager();
        this.setupSlimefun();
        this.listenerManager = new ListenerManager();
        this.getCommand("networks").setExecutor((CommandExecutor)new NetworksMain());
        this.setupMetrics();
    }

    public void tryUpdate() {
        if (this.getConfig().getBoolean("auto-update") && this.getDescription().getVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "Networks", "Dev").start();
        }
    }

    public void setupSlimefun() {
        NetworkSlimefunItems.setup();
        if (this.supportedPluginManager.isNetheopoiesis()) {
            try {
                NetheoPlants.setup();
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().severe("Netheopoiesis must be updated to meet Networks' requirements.");
            }
        }
    }

    public void setupMetrics() {
        Metrics metrics = new Metrics(this, 13644);
        AdvancedPie networksChart = new AdvancedPie("networks", () -> {
            HashMap<String, Integer> networksMap = new HashMap<String, Integer>();
            networksMap.put("Number of networks", NetworkController.getNetworks().size());
            return networksMap;
        });
        metrics.addCustomChart(networksChart);
    }

    @Nonnull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return MessageFormat.format("https://github.com/{0}/{1}/issues/", this.username, this.repo);
    }

    @Nonnull
    public static PluginManager getPluginManager() {
        return Networks.getInstance().getServer().getPluginManager();
    }

    public static Networks getInstance() {
        return instance;
    }

    public static SupportedPluginManager getSupportedPluginManager() {
        return Networks.getInstance().supportedPluginManager;
    }

    public static ListenerManager getListenerManager() {
        return Networks.getInstance().listenerManager;
    }
}

