/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.entity.display;

import dev.sefiraat.sefilib.persistence.StringListDataType;
import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.persistence.PersistentDataHolder;

public class DisplayGroup {
    private static final NamespacedKey KEY_LIST = new NamespacedKey("sefilib", "child_display_list");
    private static final NamespacedKey KEY_NAMES = new NamespacedKey("sefilib", "child_display_names");
    @Nonnull
    private final Interaction parentDisplay;
    private final Map<String, Display> displays = new HashMap<String, Display>();

    public DisplayGroup(@Nonnull Location location) {
        this(location, 1.0f, 1.0f);
    }

    public DisplayGroup(@Nonnull Location location, float height, float width) {
        this.parentDisplay = (Interaction)location.getWorld().spawnEntity(location, EntityType.INTERACTION);
        this.parentDisplay.setInteractionHeight(height);
        this.parentDisplay.setInteractionWidth(width);
        this.applyLists(new ArrayList<String>(), new ArrayList<String>());
    }

    public DisplayGroup(@Nonnull Interaction textDisplay) {
        this.parentDisplay = textDisplay;
        List<String> childList = this.getChildList();
        List<String> childNames = this.getChildNames();
        if (childList == null || childNames == null) {
            throw new IllegalArgumentException("This display was never part of a group");
        }
        if (childList.size() != childNames.size()) {
            throw new IllegalStateException("This display's memory has been borked");
        }
        for (int i = 0; i < childList.size(); ++i) {
            String s = childList.get(i);
            UUID uuid = UUID.fromString(s);
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null || entity.isDead() || !(entity instanceof Display)) continue;
            Display display = (Display)entity;
            this.displays.put(childNames.get(i), display);
        }
    }

    @Nonnull
    public Interaction getParentDisplay() {
        return this.parentDisplay;
    }

    public UUID getParentUUID() {
        return this.parentDisplay.getUniqueId();
    }

    public Location getLocation() {
        return this.parentDisplay.getLocation();
    }

    public Map<String, Display> getDisplays() {
        return Collections.unmodifiableMap(this.displays);
    }

    public void addDisplay(@Nonnull String name, @Nonnull Display display) {
        List<String> childList = this.getChildList();
        List<String> childNames = this.getChildNames();
        if (childList == null || childNames == null) {
            throw new IllegalArgumentException("This display doesn't appear to have a group");
        }
        childList.add(display.getUniqueId().toString());
        childNames.add(name);
        this.applyLists(childList, childNames);
        this.displays.put(name, display);
    }

    @Nullable
    public Display removeDisplay(@Nonnull String name) {
        Display display = this.displays.remove(name);
        if (display == null) {
            return display;
        }
        List<String> childList = this.getChildList();
        List<String> childNames = this.getChildNames();
        if (childList == null || childNames == null) {
            throw new IllegalArgumentException("This display doesn't appear to have a group");
        }
        childList.add(display.getUniqueId().toString());
        childNames.add(name);
        this.applyLists(childList, childNames);
        return display;
    }

    public void killDisplay(@Nonnull String name) {
        Display display = this.removeDisplay(name);
        if (display != null) {
            display.remove();
        }
    }

    public void remove() {
        this.displays.forEach((s, display) -> display.remove());
        this.parentDisplay.remove();
    }

    public void teleport(@Nonnull Location location) {
        this.displays.forEach((s, display) -> {
            Location offset = this.getParentDisplay().getLocation().subtract(display.getLocation());
            display.teleport(location.clone().add(offset));
        });
        this.getParentDisplay().teleport(location);
    }

    @Nullable
    private List<String> getChildList() {
        return PersistentDataAPI.get((PersistentDataHolder)this.parentDisplay, KEY_LIST, StringListDataType.TYPE);
    }

    @Nullable
    private List<String> getChildNames() {
        return PersistentDataAPI.get((PersistentDataHolder)this.parentDisplay, KEY_NAMES, StringListDataType.TYPE);
    }

    private void applyLists(@Nonnull List<String> childList, @Nonnull List<String> childNames) {
        PersistentDataAPI.set((PersistentDataHolder)this.parentDisplay, KEY_LIST, StringListDataType.TYPE, childList);
        PersistentDataAPI.set((PersistentDataHolder)this.parentDisplay, KEY_NAMES, StringListDataType.TYPE, childNames);
    }

    @Nullable
    public static DisplayGroup fromUUID(@Nonnull UUID uuid) {
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity == null || entity.isDead() || !(entity instanceof Interaction)) {
            return null;
        }
        Interaction display = (Interaction)entity;
        return DisplayGroup.fromInteraction(display);
    }

    @Nullable
    public static DisplayGroup fromInteraction(@Nonnull Interaction interaction) {
        if (PersistentDataAPI.has((PersistentDataHolder)interaction, KEY_LIST, StringListDataType.TYPE)) {
            return new DisplayGroup(interaction);
        }
        return null;
    }
}

