/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network.grid;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.GridItemRequest;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.SupportedRecipes;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.grid.AbstractGrid;
import io.github.sefiraat.networks.slimefun.network.grid.GridCache;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkCraftingGrid
extends AbstractGrid {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 3, 4, 5, 14, 23, 32, 33, 35, 41, 42, 44, 45, 47, 49, 50, 51, 52, 53};
    private static final int[] DISPLAY_SLOTS = new int[]{9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 27, 28, 29, 30, 31, 36, 37, 38, 39, 40};
    private static final int[] CRAFT_ITEMS = new int[]{6, 7, 8, 15, 16, 17, 24, 25, 26};
    private static final int INPUT_SLOT = 2;
    private static final int FILTER = 45;
    private static final int PAGE_PREVIOUS = 46;
    private static final int CHANGE_SORT = 47;
    private static final int PAGE_NEXT = 48;
    private static final int CRAFT_BUTTON_SLOT = 34;
    private static final int CRAFT_OUTPUT_SLOT = 43;
    private static final CustomItemStack CRAFT_BUTTON_STACK = new CustomItemStack(Material.CRAFTING_TABLE, Theme.CLICK_INFO.getColor() + "Craft", new String[]{Theme.CLICK_INFO + "Left Click: " + Theme.PASSIVE + "Try to Craft", Theme.CLICK_INFO + "Shift Left Click: " + Theme.PASSIVE + "Try to return items"});
    private static final Map<Location, GridCache> CACHE_MAP = new HashMap<Location, GridCache>();

    public NetworkCraftingGrid(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        for (int craftItem : CRAFT_ITEMS) {
            this.getSlotsToDrop().add(craftItem);
        }
        this.getSlotsToDrop().add(43);
    }

    @Override
    public void postRegister() {
        this.getPreset();
    }

    @Override
    @Nonnull
    public BlockMenuPreset getPreset() {
        return new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_GRID.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
                CACHE_MAP.put(menu.getLocation(), new GridCache(0, 0, GridCache.SortOrder.ALPHABETICAL));
                menu.replaceExistingItem(NetworkCraftingGrid.this.getPagePrevious(), (ItemStack)NetworkCraftingGrid.this.getPagePreviousStack());
                menu.addMenuClickHandler(NetworkCraftingGrid.this.getPagePrevious(), (p, slot, item, action) -> {
                    GridCache gridCache;
                    gridCache.setPage((gridCache = NetworkCraftingGrid.this.getCacheMap().get(menu.getLocation())).getPage() <= 0 ? 0 : gridCache.getPage() - 1);
                    CACHE_MAP.put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkCraftingGrid.this.getPageNext(), (ItemStack)NetworkCraftingGrid.this.getPageNextStack());
                menu.addMenuClickHandler(NetworkCraftingGrid.this.getPageNext(), (p, slot, item, action) -> {
                    GridCache gridCache;
                    gridCache.setPage((gridCache = NetworkCraftingGrid.this.getCacheMap().get(menu.getLocation())).getPage() >= gridCache.getMaxPages() ? gridCache.getMaxPages() : gridCache.getPage() + 1);
                    NetworkCraftingGrid.this.getCacheMap().put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkCraftingGrid.this.getChangeSort(), (ItemStack)NetworkCraftingGrid.this.getChangeSortStack());
                menu.addMenuClickHandler(NetworkCraftingGrid.this.getChangeSort(), (p, slot, item, action) -> {
                    GridCache gridCache = NetworkCraftingGrid.this.getCacheMap().get(menu.getLocation());
                    if (gridCache.getSortOrder() == GridCache.SortOrder.ALPHABETICAL) {
                        gridCache.setSortOrder(GridCache.SortOrder.NUMBER);
                    } else {
                        gridCache.setSortOrder(GridCache.SortOrder.ALPHABETICAL);
                    }
                    NetworkCraftingGrid.this.getCacheMap().put(menu.getLocation(), gridCache);
                    return false;
                });
                menu.replaceExistingItem(NetworkCraftingGrid.this.getFilterSlot(), (ItemStack)NetworkCraftingGrid.this.getFilterStack());
                menu.addMenuClickHandler(NetworkCraftingGrid.this.getFilterSlot(), (p, slot, item, action) -> {
                    GridCache gridCache = NetworkCraftingGrid.this.getCacheMap().get(menu.getLocation());
                    return NetworkCraftingGrid.this.setFilter(p, menu, gridCache, action);
                });
                for (int displaySlot : NetworkCraftingGrid.this.getDisplaySlots()) {
                    menu.replaceExistingItem(displaySlot, null);
                    menu.addMenuClickHandler(displaySlot, (p, slot, item, action) -> false);
                }
                menu.replaceExistingItem(34, (ItemStack)CRAFT_BUTTON_STACK);
                menu.addMenuClickHandler(34, (player, slot, item, action) -> {
                    if (action.isShiftClicked()) {
                        NetworkCraftingGrid.this.tryReturnItems(menu);
                    } else {
                        NetworkCraftingGrid.this.tryCraft(menu, player);
                    }
                    return false;
                });
            }
        };
    }

    @Override
    @Nonnull
    protected Map<Location, GridCache> getCacheMap() {
        return CACHE_MAP;
    }

    @Override
    public int[] getBackgroundSlots() {
        return BACKGROUND_SLOTS;
    }

    @Override
    public int[] getDisplaySlots() {
        return DISPLAY_SLOTS;
    }

    @Override
    public int getInputSlot() {
        return 2;
    }

    @Override
    public int getChangeSort() {
        return 47;
    }

    @Override
    public int getPagePrevious() {
        return 46;
    }

    @Override
    public int getPageNext() {
        return 48;
    }

    @Override
    protected int getFilterSlot() {
        return 45;
    }

    private void tryCraft(@Nonnull BlockMenu menu, @Nonnull Player player) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(menu.getLocation());
        if (definition.getNode() == null) {
            return;
        }
        ItemStack[] inputs = new ItemStack[CRAFT_ITEMS.length];
        int i = 0;
        for (int recipeSlot : CRAFT_ITEMS) {
            ItemStack stack;
            inputs[i] = stack = menu.getItemInSlot(recipeSlot);
            ++i;
        }
        ItemStack crafted = null;
        for (Map.Entry<ItemStack[], ItemStack> entry : SupportedRecipes.getRecipes().entrySet()) {
            if (!SupportedRecipes.testRecipe(inputs, entry.getKey())) continue;
            crafted = entry.getValue().clone();
            break;
        }
        if (crafted == null) {
            crafted = Bukkit.craftItem((ItemStack[])inputs, (World)player.getWorld(), (Player)player);
        }
        if (crafted.getType() == Material.AIR || !menu.fits(crafted, new int[]{43})) {
            return;
        }
        menu.pushItem(crafted, new int[]{43});
        for (Object recipeSlot : (Object)CRAFT_ITEMS) {
            ItemStack itemInSlot = menu.getItemInSlot((int)recipeSlot);
            if (itemInSlot == null) continue;
            ItemStack itemInSlotClone = itemInSlot.clone();
            itemInSlotClone.setAmount(1);
            ItemUtils.consumeItem((ItemStack)menu.getItemInSlot((int)recipeSlot), (int)1, (boolean)true);
            if (menu.getItemInSlot((int)recipeSlot) != null) continue;
            GridItemRequest request = new GridItemRequest(itemInSlotClone, 1, player);
            ItemStack requestingStack = definition.getNode().getRoot().getItemStack(request);
            if (requestingStack == null) continue;
            menu.replaceExistingItem((int)recipeSlot, requestingStack);
        }
    }

    private void tryReturnItems(@Nonnull BlockMenu menu) {
        NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(menu.getLocation());
        if (definition.getNode() == null) {
            return;
        }
        for (int recipeSlot : CRAFT_ITEMS) {
            ItemStack stack = menu.getItemInSlot(recipeSlot);
            if (stack == null || stack.getType() == Material.AIR) continue;
            definition.getNode().getRoot().addItemStack(stack);
        }
    }
}

