/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.slimefun.network;

import io.github.sefiraat.networks.NetworkStorage;
import io.github.sefiraat.networks.network.NetworkRoot;
import io.github.sefiraat.networks.network.NodeDefinition;
import io.github.sefiraat.networks.network.NodeType;
import io.github.sefiraat.networks.slimefun.NetworkSlimefunItems;
import io.github.sefiraat.networks.slimefun.network.NetworkObject;
import io.github.sefiraat.networks.utils.Theme;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NetworkPowerDisplay
extends NetworkObject {
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
    private static final int DISPLAY_SLOT = 4;
    private static final CustomItemStack EMPTY = new CustomItemStack(Material.RED_STAINED_GLASS_PANE, Theme.CLICK_INFO + "Status", new String[]{Theme.PASSIVE + "Disconnected"});

    public NetworkPowerDisplay(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe, NodeType.POWER_DISPLAY);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block block, SlimefunItem slimefunItem, Config config) {
                BlockMenu blockMenu = BlockStorage.getInventory((Block)block);
                if (blockMenu != null) {
                    NetworkPowerDisplay.this.addToRegistry(block);
                    NetworkPowerDisplay.this.setDisplay(blockMenu);
                }
            }
        }});
    }

    private void setDisplay(BlockMenu blockMenu) {
        if (blockMenu.hasViewer()) {
            NodeDefinition definition = NetworkStorage.getAllNetworkObjects().get(blockMenu.getLocation());
            if (definition.getNode() == null) {
                blockMenu.replaceExistingItem(4, (ItemStack)EMPTY);
                return;
            }
            NetworkRoot root = definition.getNode().getRoot();
            long networkCharge = root.getRootPower();
            blockMenu.replaceExistingItem(4, (ItemStack)NetworkPowerDisplay.getChargeStack(networkCharge));
        }
    }

    public void postRegister() {
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                this.drawBackground(BACKGROUND_SLOTS);
                this.addItem(4, (ItemStack)NetworkPowerDisplay.getChargeStack(0L), (player, i, itemStack, clickAction) -> false);
            }

            public boolean canOpen(@Nonnull Block block, @Nonnull Player player) {
                return NetworkSlimefunItems.NETWORK_POWER_DISPLAY.canUse(player, false) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, block.getLocation(), Interaction.INTERACT_BLOCK);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }
        };
    }

    private static CustomItemStack getChargeStack(long charge) {
        return new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, Theme.CLICK_INFO + "Status", new String[]{Theme.PASSIVE + "Current Network Charge: " + charge + "j"});
    }
}

