/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.networks.network.stackcaches;

import io.github.sefiraat.networks.network.stackcaches.ItemStackCache;
import io.github.sefiraat.networks.utils.Theme;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CardInstance
extends ItemStackCache {
    private int amount;
    private final int limit;

    public CardInstance(@Nullable ItemStack itemStack, int amount, int limit) {
        super(itemStack);
        this.amount = amount;
        this.limit = limit;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Nullable
    public ItemStack withdrawItem(int amount) {
        if (this.getItemStack() == null) {
            return null;
        }
        ItemStack clone = this.getItemStack().clone();
        clone.setAmount(Math.min(this.amount, amount));
        this.reduceAmount(clone.getAmount());
        return clone;
    }

    @Nullable
    public ItemStack withdrawItem() {
        if (this.getItemStack() == null) {
            return null;
        }
        return this.withdrawItem(this.getItemStack().getMaxStackSize());
    }

    public void increaseAmount(int amount) {
        long total = (long)this.amount + (long)amount;
        this.amount = total > (long)this.limit ? this.limit : (this.amount += amount);
    }

    public void reduceAmount(int amount) {
        this.amount -= amount;
    }

    public void updateLore(@Nonnull ItemMeta itemMeta) {
        List lore = itemMeta.getLore();
        lore.set(10, this.getLoreLine());
        itemMeta.setLore(lore);
    }

    public String getLoreLine() {
        if (this.getItemStack() == null) {
            return Theme.WARNING + "Empty";
        }
        ItemMeta itemMeta = this.getItemMeta();
        String name = itemMeta != null && itemMeta.hasDisplayName() ? ChatColor.stripColor((String)itemMeta.getDisplayName()) : (this.getItemType() != null ? this.getItemType().name() : "Unknown/Error");
        return Theme.CLICK_INFO + name + ": " + Theme.PASSIVE + this.amount;
    }
}

