/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.slimefun.recipes;

import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ConfigurableRecipeItem {
    public static final ConfigurableRecipeItem EMPTY = new ConfigurableRecipeItem();
    private final ItemType itemType;
    private Material material = null;
    private String slimefunId = null;
    private ItemStack itemStack = null;

    public ConfigurableRecipeItem(@Nonnull Material material) {
        this.itemType = ItemType.MATERIAL;
        this.material = material;
    }

    public ConfigurableRecipeItem(@Nonnull String slimefunId) {
        this.itemType = ItemType.SLIMEFUN;
        this.slimefunId = slimefunId;
    }

    public ConfigurableRecipeItem(@Nonnull ItemStack itemStack) {
        this.itemType = ItemType.ITEMSTACK;
        this.itemStack = itemStack;
    }

    private ConfigurableRecipeItem() {
        this.itemType = ItemType.EMPTY;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getSlimefunId() {
        return this.slimefunId;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public static ConfigurableRecipeItem fromConfig(@Nonnull ConfigurationSection section) throws IllegalArgumentException, IllegalStateException {
        ItemType type = ItemType.valueOf(section.getString("type", ItemType.SLIMEFUN.name()));
        String value = section.getString("value");
        if (value == null) {
            throw new IllegalArgumentException("No value was provided");
        }
        switch (type) {
            case SLIMEFUN: {
                return new ConfigurableRecipeItem(value);
            }
            case MATERIAL: {
                Material material = Material.valueOf((String)value);
                return new ConfigurableRecipeItem(material);
            }
            case ITEMSTACK: {
                ItemStack itemStack = section.getItemStack("value");
                if (itemStack == null) {
                    throw new IllegalArgumentException("ItemStack is missing or invalid");
                }
                return new ConfigurableRecipeItem(itemStack);
            }
            case EMPTY: {
                return EMPTY;
            }
        }
        throw new IllegalStateException("Unexpected value: " + type);
    }

    public static enum ItemType {
        SLIMEFUN,
        MATERIAL,
        ITEMSTACK,
        EMPTY;

    }
}

