/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.utils;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class WorldUtils {
    private WorldUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void dropItem(ItemStack i, @Nonnull Player p) {
        WorldUtils.dropItem(p.getWorld(), p.getLocation(), i);
    }

    public static void dropItem(ItemStack i, @Nonnull Location l) {
        WorldUtils.dropItem(l.getWorld(), l, i);
    }

    public static void dropItem(ItemStack i, @Nonnull Block b) {
        WorldUtils.dropItem(b.getWorld(), b.getLocation(), i);
    }

    public static void dropItem(@Nonnull World w, Location l, ItemStack i) {
        w.dropItemNaturally(l, i);
    }

    @Nonnull
    public static Location getMid(@Nonnull World world, double x1, double y1, double z1, double x2, double y2, double z2) {
        return new Location(world, x1 + (x2 - x1) * 0.5, y1 + (y2 - y1) * 0.5, z1 + (z2 - z1) * 0.5);
    }

    @Nullable
    public static Block getRandomBlockInRange(@Nonnull Location l, int boundX, int boundY, int boundZ, boolean allowAir) {
        return WorldUtils.getRandomBlockInRange(l, boundX, boundY, boundZ, allowAir, 1);
    }

    @Nullable
    public static Block getRandomBlockInRange(@Nonnull Player p, int boundX, int boundY, int boundZ, boolean allowAir) {
        return WorldUtils.getRandomBlockInRange(p.getLocation(), boundX, boundY, boundZ, allowAir, 1);
    }

    @Nullable
    public static Block getRandomBlockInRange(@Nonnull Block b, int boundX, int boundY, int boundZ, boolean allowAir) {
        return WorldUtils.getRandomBlockInRange(b.getLocation(), boundX, boundY, boundZ, allowAir, 1);
    }

    @Nullable
    private static Block getRandomBlockInRange(@Nonnull Location l, int boundX, int boundY, int boundZ, boolean allowAir, int ittr) {
        if (ittr < 50) {
            int rndX = ThreadLocalRandom.current().nextInt(-boundX, boundX + 1);
            int rndY = ThreadLocalRandom.current().nextInt(-boundY, boundY + 1);
            int rndZ = ThreadLocalRandom.current().nextInt(-boundZ, boundZ + 1);
            Block b = l.getBlock().getRelative(rndX, rndY, rndZ);
            if (allowAir || b.getType() != Material.AIR) {
                return b;
            }
            return WorldUtils.getRandomBlockInRange(l, boundX, boundY, boundZ, false, ittr + 1);
        }
        return null;
    }

    @Nonnull
    public static Location getRandomLocationInRange(@Nonnull Block b, int boundX, int boundY, int boundZ) {
        return WorldUtils.getRandomLocationInRange(b.getLocation(), boundX, boundY, boundZ);
    }

    @Nonnull
    public static Location getRandomLocationInRange(@Nonnull Entity e, int boundX, int boundY, int boundZ) {
        return WorldUtils.getRandomLocationInRange(e.getLocation(), boundX, boundY, boundZ);
    }

    @Nonnull
    public static Location getRandomLocationInRange(@Nonnull Location l, int boundX, int boundY, int boundZ) {
        int rndX = ThreadLocalRandom.current().nextInt(-boundX, boundX + 1);
        int rndY = ThreadLocalRandom.current().nextInt(-boundY, boundY + 1);
        int rndZ = ThreadLocalRandom.current().nextInt(-boundZ, boundZ + 1);
        return l.clone().add((double)rndX, (double)rndY, (double)rndZ);
    }
}

