/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.templates;

import io.github.sefiraat.slimetinker.items.templates.ArmourDefinition;
import io.github.sefiraat.slimetinker.items.tinkermaterials.TinkerMaterialManager;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.text.MessageFormat;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class ArmourTemplate
extends UnplaceableBlock {
    public ArmourTemplate(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public String getName(ArmourDefinition armourDefinition) {
        return MessageFormat.format("{0}{1}-{2}{3}-{4}{5} {6}{7}", TinkerMaterialManager.getById(armourDefinition.getPlateMaterial()).getColor(), ThemeUtils.toTitleCase(armourDefinition.getPlateMaterial()), TinkerMaterialManager.getById(armourDefinition.getGambesonMaterial()).getColor(), ThemeUtils.toTitleCase(armourDefinition.getGambesonMaterial()), TinkerMaterialManager.getById(armourDefinition.getLinksMaterial()).getColor(), ThemeUtils.toTitleCase(armourDefinition.getLinksMaterial()), ChatColor.WHITE, ThemeUtils.toTitleCase(armourDefinition.getPartType()));
    }

    public Material getMaterial(ArmourDefinition armourDefinition) {
        switch (armourDefinition.getPartType()) {
            case "HELMET": {
                return Material.LEATHER_HELMET;
            }
            case "CHESTPLATE": {
                return Material.LEATHER_CHESTPLATE;
            }
            case "LEGGINGS": {
                return Material.LEATHER_LEGGINGS;
            }
            case "BOOTS": {
                return Material.LEATHER_BOOTS;
            }
        }
        throw new IllegalStateException("Unexpected value: " + armourDefinition.getClassType());
    }

    public ItemStack getStack(ArmourDefinition armourDefinition) {
        ItemStack itemStack = this.getItem().clone();
        itemStack.setType(this.getMaterial(armourDefinition));
        ItemMeta im = itemStack.getItemMeta();
        Experience.setupExpNew(im);
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_IS_ARMOUR, (String)"Y");
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_PLATE_TYPE, (String)armourDefinition.getClassType());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_ARMOUR_TYPE, (String)armourDefinition.getPartType());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_PLATE_MATERIAL, (String)armourDefinition.getPlateMaterial());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_GAMBESON_MATERIAL, (String)armourDefinition.getGambesonMaterial());
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.ARMOUR_INFO_LINKS_MATERIAL, (String)armourDefinition.getLinksMaterial());
        im.setDisplayName(this.getName(armourDefinition));
        itemStack.setItemMeta(im);
        ItemUtils.rebuildTinkerLore(itemStack);
        return itemStack;
    }
}

