/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.runnables;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmourRemove
extends BukkitRunnable {
    public void run() {
        for (Player player : SlimeTinker.getInstance().getServer().getOnlinePlayers()) {
            ItemStack helmet = player.getInventory().getHelmet();
            ItemStack chestplate = player.getInventory().getChestplate();
            ItemStack leggings = player.getInventory().getLeggings();
            ItemStack boots = player.getInventory().getBoots();
            if (ItemUtils.isArmour(helmet) && ItemUtils.isTinkersBroken(helmet) && ItemUtils.doesUnequipWhenBroken(helmet)) {
                this.unequip(player, helmet);
            }
            if (ItemUtils.isArmour(chestplate) && ItemUtils.isTinkersBroken(chestplate) && ItemUtils.doesUnequipWhenBroken(chestplate)) {
                this.unequip(player, chestplate);
            }
            if (ItemUtils.isArmour(leggings) && ItemUtils.isTinkersBroken(leggings) && ItemUtils.doesUnequipWhenBroken(leggings)) {
                this.unequip(player, leggings);
            }
            if (!ItemUtils.isArmour(boots) || !ItemUtils.isTinkersBroken(boots) || !ItemUtils.doesUnequipWhenBroken(boots)) continue;
            this.unequip(player, boots);
        }
    }

    private void unequip(@Nonnull Player player, @Nonnull ItemStack itemStack) {
        PlayerInventory i = player.getInventory();
        ItemStack newItem = itemStack.clone();
        itemStack.setAmount(0);
        if (i.firstEmpty() > -1) {
            i.addItem(new ItemStack[]{newItem});
            player.sendMessage(ThemeUtils.WARNING + "A piece of armour has broken! It's been placed in your inventory.");
        } else {
            player.getWorld().dropItemNaturally(player.getLocation(), newItem);
            player.sendMessage(ThemeUtils.WARNING + "A piece of armour has broken! You had no room for it and it has been dropped.");
        }
    }
}

