/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.listeners;

import io.github.sefiraat.slimetinker.events.friend.EventChannels;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.modifiers.Modifications;
import io.github.sefiraat.slimetinker.utils.EntityUtils;
import io.github.sefiraat.slimetinker.utils.Experience;
import io.github.sefiraat.slimetinker.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class EntityKilledListener
implements Listener {
    protected final Map<Player, List<ItemStack>> heldItems = new HashMap<Player, List<ItemStack>>();

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.heldItems.containsKey(p)) {
            list.addAll((Collection)this.heldItems.get(p));
        }
        for (ItemStack i : event.getDrops()) {
            if (!ItemUtils.cannotDrop(i)) continue;
            list.add(i);
        }
        for (ItemStack i : list) {
            event.getDrops().remove(i);
        }
        this.heldItems.put(p, list);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player p = event.getPlayer();
        if (this.heldItems.containsKey(p)) {
            for (ItemStack i : this.heldItems.get(p)) {
                p.getInventory().addItem(new ItemStack[]{i});
            }
        }
        this.heldItems.remove(p);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity dyingEntity = event.getEntity();
        if (dyingEntity.getKiller() == null || this.isInvalidEvent(event)) {
            return;
        }
        Player player = dyingEntity.getKiller();
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        EventFriend friend = new EventFriend(player, TraitEventType.ENTITY_DAMAGED);
        friend.setDamagedEntity((Entity)dyingEntity);
        EventChannels.checkTool(friend);
        EventChannels.checkArmour(friend);
        if (friend.isActionTaken()) {
            this.modChecks(event, heldItem);
            EventChannels.settlePotionEffects(friend);
            int rawExp = event.getDroppedExp();
            event.setDroppedExp((int)Math.ceil((double)event.getDroppedExp() * friend.getPlayerExpMod()));
            if (event.getDroppedExp() > 0 && friend.isMetalCheck()) {
                Experience.addExp(heldItem, (int)Math.ceil((double)event.getDroppedExp() / 10.0), player, true);
                event.setDroppedExp(0);
            } else {
                EventChannels.provideKillExp(friend, rawExp);
            }
        }
    }

    private void modChecks(EntityDeathEvent event, ItemStack heldItem) {
        this.modCheckLapis(event, heldItem);
    }

    private void modCheckLapis(EntityDeathEvent event, ItemStack heldItem) {
        Map<String, Integer> modLevels = Modifications.getAllModLevels(heldItem);
        if (!modLevels.containsKey(Material.LAPIS_LAZULI.toString())) {
            return;
        }
        if (event.getEntity() instanceof ChestedHorse || event.getEntity() instanceof Player) {
            return;
        }
        int lapisLevel = modLevels.get(Material.LAPIS_LAZULI.toString());
        LivingEntity entity = event.getEntity();
        for (ItemStack drop : event.getDrops()) {
            int additionalAmount = (int)Math.floor((double)drop.getAmount() * ((double)lapisLevel * 0.1));
            if (additionalAmount <= 0) continue;
            ItemStack additionalDrop = new ItemStack(drop.getType());
            additionalDrop.setAmount(additionalAmount);
            Location location = entity.getLocation().clone().add(0.5, 0.5, 0.5);
            entity.getWorld().dropItemNaturally(location, additionalDrop);
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.BLUE, 2.0f);
            entity.getWorld().spawnParticle(Particle.REDSTONE, location, 10, 0.2, 0.2, 0.2, 0.5, (Object)dustOptions);
        }
    }

    private boolean isInvalidEvent(@Nonnull EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        return EntityUtils.isTrainingDummy((Entity)entity) || EntityUtils.shouldIgnoreDamage((Entity)entity);
    }
}

