/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.tinkermaterials;

import io.github.sefiraat.slimetinker.SlimeTinker;
import io.github.sefiraat.slimetinker.events.friend.EventFriend;
import io.github.sefiraat.slimetinker.events.friend.TraitEventType;
import io.github.sefiraat.slimetinker.events.friend.TraitPartType;
import io.github.sefiraat.slimetinker.itemgroups.ItemGroups;
import io.github.sefiraat.slimetinker.items.Casts;
import io.github.sefiraat.slimetinker.items.templates.PartTemplate;
import io.github.sefiraat.slimetinker.items.tinkermaterials.elements.Alloy;
import io.github.sefiraat.slimetinker.items.tinkermaterials.elements.Liquid;
import io.github.sefiraat.slimetinker.items.tinkermaterials.elements.MaterialTrait;
import io.github.sefiraat.slimetinker.items.workstations.smeltery.DummySmeltery;
import io.github.sefiraat.slimetinker.items.workstations.workbench.Workbench;
import io.github.sefiraat.slimetinker.managers.TraitManager;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.sefiraat.slimetinker.utils.enums.ThemeItemType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class TinkerMaterial {
    private final String id;
    private final ItemStack representativeStack;
    @Nullable
    private String liquidTexture;
    private final String colorHex;
    @Nullable
    private Liquid liquid;
    @Nullable
    private MaterialTrait traitToolHead;
    @Nullable
    private MaterialTrait traitToolBinder;
    @Nullable
    private MaterialTrait traitToolRod;
    @Nullable
    private MaterialTrait traitArmorPlates;
    @Nullable
    private MaterialTrait traitArmorGambeson;
    @Nullable
    private MaterialTrait traitArmorLinks;
    @Nullable
    private String formNugget;
    @Nullable
    private String formIngot;
    @Nullable
    private String formBlock;
    @Nullable
    private String formOre;
    @Nullable
    private String formGem;
    @Nullable
    private String formDust;
    @Nullable
    private String formBoots;
    @Nullable
    private String formLeggings;
    @Nullable
    private String formChestplate;
    @Nullable
    private String formHelmet;
    @Nullable
    private Alloy alloy;
    @Nullable
    private SlimefunItemStack[] alloyRecipe;

    @ParametersAreNonnullByDefault
    public TinkerMaterial(String id, ItemStack representativeStack, String colorHex) {
        this.id = id;
        this.representativeStack = representativeStack;
        this.colorHex = colorHex;
    }

    public TinkerMaterial build() {
        if (this.liquid != null) {
            this.liquid.setupLiquid(this);
        }
        if (this.alloy != null) {
            this.alloy.setupAlloy(this);
        }
        this.setupTraits();
        this.registerParts();
        return this;
    }

    public void setupTraits() {
        TraitManager manager = SlimeTinker.getInstance().getTraitManager();
        if (this.traitToolHead != null && manager.getEnabled(this.id, "HEAD")) {
            this.traitToolHead.setupTrait(this);
        }
        if (this.traitToolBinder != null && manager.getEnabled(this.id, "BINDING")) {
            this.traitToolBinder.setupTrait(this);
        }
        if (this.traitToolRod != null && manager.getEnabled(this.id, "ROD")) {
            this.traitToolRod.setupTrait(this);
        }
        if (this.traitArmorPlates != null && manager.getEnabled(this.id, "PLATE")) {
            this.traitArmorPlates.setupTrait(this);
        }
        if (this.traitArmorGambeson != null && manager.getEnabled(this.id, "GAMBESON")) {
            this.traitArmorGambeson.setupTrait(this);
        }
        if (this.traitArmorLinks != null && manager.getEnabled(this.id, "LINKS")) {
            this.traitArmorLinks.setupTrait(this);
        }
        manager.save();
    }

    public void registerParts() {
        SlimeTinker plugin = SlimeTinker.getInstance();
        TraitManager traitManager = plugin.getTraitManager();
        if (this.traitToolHead != null && traitManager.isEnabled(this.id, "HEAD")) {
            new PartTemplate(ItemGroups.PART_DICT, this.headStack(this.id, "SWORD", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTBkZmM4YTM1NjNiZjk5NmY1YzFiNzRiMGIwMTViMmNjZWIyZDA0Zjk0YmJjZGFmYjIyOTlkOGE1OTc5ZmFjMSJ9fX0="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_SWORDBLADE, (ItemStack)this.getLiquidItemStack(2)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.headStack(this.id, "HOE", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzMyMzVjOThkYjA3Zjk3NmRlZjI3Y2VhYWNhODljNzcxNzgzMWI0YmNjN2YyZjNhMTQ2MjJlNzhjMmRiZSJ9fX0="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_HOEHEAD, (ItemStack)this.getLiquidItemStack(1)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.headStack(this.id, "AXE", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjRiYTQ5Mzg0ZGJhN2I3YWNkYjRmNzBlOTM2MWU2ZDU3Y2JiY2JmNzIwY2Y0ZjE2YzJiYjgzZTQ1NTcifX19"), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_AXEHEAD, (ItemStack)this.getLiquidItemStack(1)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.headStack(this.id, "PICK", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjZlYTIxMzU4Mzg0NjE1MzQzNzJmMmRhNmM4NjJkMjFjZDVmM2QyYzcxMTlmMmJiNjc0YmJkNDI3OTEifX19"), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_PICKAXEHEAD, (ItemStack)this.getLiquidItemStack(1)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.headStack(this.id, "SHOVEL", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMThkN2QxOWEzZmQ4ZTI2NTI0YWFiMzJmOTQ0ZGM3ZDJmNTYwZTFkOGZlMTc4ZTg5M2NlZWE3NGNmY2YifX19"), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_SHOVELHEAD, (ItemStack)this.getLiquidItemStack(1)), this.id).register(plugin);
        }
        if (this.traitToolBinder != null && traitManager.isEnabled(this.id, "BINDING")) {
            PartTemplate binder = new PartTemplate(ItemGroups.DUMMY, this.bindingStack(this.id), Workbench.TYPE, this.bindingRecipe(this.representativeStack), this.id);
            binder.setHidden(true);
            binder.register(plugin);
        }
        if (this.traitToolRod != null && traitManager.isEnabled(this.id, "ROD")) {
            new PartTemplate(ItemGroups.PART_DICT, this.rodStack(this.id), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_TOOLROD, (ItemStack)this.getLiquidItemStack(1)), this.id).register(plugin);
        }
        if (this.traitArmorPlates != null && traitManager.isEnabled(this.id, "PLATE")) {
            new PartTemplate(ItemGroups.PART_DICT, this.platesStack(this.id, "HELMET", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmIyNzI1OTI0ZTA5ZDZiMGJkZjVhYjg2NGU2M2Y4MGViODgwYmZhNmZlMWZhMTdmOWZkYjYxYmMxYWUxMTBkYiJ9fX0="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_HELM_PLATE, (ItemStack)this.getLiquidItemStack(45)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.platesStack(this.id, "CHESTPLATE", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWU3ZTUxNTdmODA1Y2VjMDk5NjljYzM1MTAxNzlkMzk4NzQwMmM1NGQxOGMxMjQ2YmIxNGRiM2FkNTBlZjQxYiJ9fX0="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_CHEST_PLATE, (ItemStack)this.getLiquidItemStack(72)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.platesStack(this.id, "LEGGINGS", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDlhMGM2ZTc5ZDBlZjNjODI4NjUxNWRkMjRiYWE4MzliYmRiZWRhNmNiOWYxMzZjN2NkMTg2YjA3MGM0ZDg3In19fQ=="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_LEG_PLATE, (ItemStack)this.getLiquidItemStack(63)), this.id).register(plugin);
            new PartTemplate(ItemGroups.PART_DICT, this.platesStack(this.id, "BOOTS", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTQzZGExN2Y1YTYzNGJjNGE3NTZmZDFmMDI1ZWJhMmVmMWVjMTdiMTU4YTE5Zjc5YTJiMWY3MTIxZmQ5MDljYiJ9fX0="), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_BOOT_PLATE, (ItemStack)this.getLiquidItemStack(36)), this.id).register(plugin);
        }
        if (this.traitArmorGambeson != null && traitManager.isEnabled(this.id, "GAMBESON")) {
            PartTemplate gambeson = new PartTemplate(ItemGroups.DUMMY, this.gambesonStack(this.id), Workbench.TYPE, this.gambesonRecipe(this.representativeStack), this.id);
            gambeson.setHidden(true);
            gambeson.register(plugin);
        }
        if (this.traitArmorLinks != null && traitManager.isEnabled(this.id, "LINKS")) {
            new PartTemplate(ItemGroups.PART_DICT, this.linksStack(this.id), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_MAIL_LINK, (ItemStack)this.getLiquidItemStack(18)), this.id).register(plugin);
        }
        if (this.traitToolHead != null || this.traitArmorPlates != null) {
            new PartTemplate(ItemGroups.PART_DICT, this.repairStack(this.id), DummySmeltery.TYPE, this.basicRecipe((ItemStack)Casts.CAST_REPAIRKIT, (ItemStack)this.getLiquidItemStack(27)), this.id).register(plugin);
        }
    }

    public TinkerMaterial setLiquidTexture(@Nonnull String liquidTexture) {
        this.liquidTexture = liquidTexture;
        this.liquid = new Liquid(liquidTexture);
        return this;
    }

    public TinkerMaterial addAlloyRecipe(SlimefunItemStack ... alloyRecipe) {
        this.alloyRecipe = alloyRecipe;
        this.alloy = new Alloy(alloyRecipe);
        return this;
    }

    @Nullable
    public MaterialTrait getTraitToolHead() {
        return this.traitToolHead;
    }

    public TinkerMaterial setTraitToolHead(@Nullable MaterialTrait traitToolHead) {
        this.traitToolHead = traitToolHead;
        return this;
    }

    @Nullable
    public MaterialTrait getTraitToolBinder() {
        return this.traitToolBinder;
    }

    public TinkerMaterial setTraitToolBinder(@Nullable MaterialTrait traitToolBinding) {
        this.traitToolBinder = traitToolBinding;
        return this;
    }

    @Nullable
    public MaterialTrait getTraitToolRod() {
        return this.traitToolRod;
    }

    public TinkerMaterial setTraitToolRod(@Nullable MaterialTrait traitToolRod) {
        this.traitToolRod = traitToolRod;
        return this;
    }

    @Nullable
    public MaterialTrait getTraitArmorPlates() {
        return this.traitArmorPlates;
    }

    public TinkerMaterial setTraitArmorPlates(@Nullable MaterialTrait traitArmorPlates) {
        this.traitArmorPlates = traitArmorPlates;
        return this;
    }

    @Nullable
    public MaterialTrait getTraitArmorGambeson() {
        return this.traitArmorGambeson;
    }

    public TinkerMaterial setTraitArmorGambeson(@Nullable MaterialTrait traitArmorGambeson) {
        this.traitArmorGambeson = traitArmorGambeson;
        return this;
    }

    @Nullable
    public MaterialTrait getTraitArmorLinks() {
        return this.traitArmorLinks;
    }

    public TinkerMaterial setTraitArmorLinks(@Nullable MaterialTrait traitArmorLinks) {
        this.traitArmorLinks = traitArmorLinks;
        return this;
    }

    @Nullable
    public String getFormNugget() {
        return this.formNugget;
    }

    public TinkerMaterial setFormNugget(@Nullable String formNugget) {
        this.formNugget = formNugget;
        return this;
    }

    @Nullable
    public String getFormIngot() {
        return this.formIngot;
    }

    public TinkerMaterial setFormIngot(@Nullable String formIngot) {
        this.formIngot = formIngot;
        return this;
    }

    @Nullable
    public String getFormBlock() {
        return this.formBlock;
    }

    public TinkerMaterial setFormBlock(@Nullable String formBlock) {
        this.formBlock = formBlock;
        return this;
    }

    @Nullable
    public String getFormOre() {
        return this.formOre;
    }

    public TinkerMaterial setFormOre(@Nullable String formOre) {
        this.formOre = formOre;
        return this;
    }

    @Nullable
    public String getFormGem() {
        return this.formGem;
    }

    public TinkerMaterial setFormGem(@Nullable String formGem) {
        this.formGem = formGem;
        return this;
    }

    @Nullable
    public String getFormDust() {
        return this.formDust;
    }

    public TinkerMaterial setFormDust(@Nullable String formDust) {
        this.formDust = formDust;
        return this;
    }

    @Nullable
    public String getFormBoots() {
        return this.formBoots;
    }

    public TinkerMaterial setFormBoots(@Nullable String formBoots) {
        this.formBoots = formBoots;
        return this;
    }

    @Nullable
    public String getFormLeggings() {
        return this.formLeggings;
    }

    public TinkerMaterial setFormLeggings(@Nullable String formLeggings) {
        this.formLeggings = formLeggings;
        return this;
    }

    @Nullable
    public String getFormChestplate() {
        return this.formChestplate;
    }

    public TinkerMaterial setFormChestplate(@Nullable String formChestplate) {
        this.formChestplate = formChestplate;
        return this;
    }

    @Nullable
    public String getFormHelmet() {
        return this.formHelmet;
    }

    public TinkerMaterial setFormHelmet(@Nullable String formHelmet) {
        this.formHelmet = formHelmet;
        return this;
    }

    public ChatColor getColor() {
        return ChatColor.of((String)this.colorHex);
    }

    public SlimefunItemStack getLiquidItemStack(int amount) {
        return new SlimefunItemStack(this.liquid.getItemStack(), amount);
    }

    public String getId() {
        return this.id;
    }

    public String getLiquidTexture() {
        return this.liquidTexture;
    }

    public ItemStack getRepresentativeStack() {
        return this.representativeStack;
    }

    @Nullable
    public SlimefunItemStack[] getAlloyRecipe() {
        return this.alloyRecipe;
    }

    @Nullable
    public Liquid getCmLiquid() {
        return this.liquid;
    }

    @Nullable
    public Alloy getCmAlloy() {
        return this.alloy;
    }

    @Nonnull
    private SlimefunItemStack headStack(String name, String type, String skullTexture) {
        String titName = ThemeUtils.toTitleCase(name);
        return ThemeUtils.themedItemStack("PART_HEAD_" + type + name, skullTexture, ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " " + ThemeUtils.toTitleCase(type) + " Head", ThemeUtils.PASSIVE + "A tool head made of " + titName + ".");
    }

    @Nonnull
    private SlimefunItemStack bindingStack(String name) {
        String titName = ThemeUtils.toTitleCase(name);
        SlimefunItemStack i = ThemeUtils.themedItemStack("PART_BINDING_" + name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTg3M2MyZWVlN2EyY2M1NGQ2OWI3MzY1MDUzZWUxMGRjYjc4YmIwMDA0MGJhNTZmOTZiYWU1ZWUyZDdkMzJhOCJ9fX0=", ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " Binding", ThemeUtils.PASSIVE + "A binding made of " + titName + ".");
        ItemMeta im = i.getItemMeta();
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_MATERIAL, (String)name);
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_CLASS, (String)"BINDING");
        i.setItemMeta(im);
        return i;
    }

    @Nonnull
    private SlimefunItemStack rodStack(String name) {
        String titName = ThemeUtils.toTitleCase(name);
        return ThemeUtils.themedItemStack("PART_ROD_" + name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODNmYTMwYTE5YmE5ODk3OWNlMGM3NjRhN2JiMGNmMTg0NzFjN2YyODU1ZDQ0MzQzNTk3NmU5NzJjNTFiODQ2ZiJ9fX0=", ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " Rod", ThemeUtils.PASSIVE + "A tool rod made of " + titName + ".");
    }

    @Nonnull
    private SlimefunItemStack platesStack(String name, String type, String skullTexture) {
        String titName = ThemeUtils.toTitleCase(name);
        return ThemeUtils.themedItemStack("PART_PLATES_" + type + name, skullTexture, ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " " + ThemeUtils.toTitleCase(type) + " Plates", ThemeUtils.PASSIVE + "A set of armour plates made of " + titName + ".");
    }

    @Nonnull
    private SlimefunItemStack gambesonStack(String name) {
        String titName = ThemeUtils.toTitleCase(name);
        SlimefunItemStack i = ThemeUtils.themedItemStack("PART_GAMBESON_" + name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWNiNzdhOWNlYmUxYzE5NjIxMDUyN2EwNjk4OTNiOGY2Mzk1NGIzNDc1NzIwZjgwNDBmZTEyMzNhYWY4OWYwZiJ9fX0=", ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " Gambeson", ThemeUtils.PASSIVE + "A gambeson made of " + titName + ".");
        ItemMeta im = i.getItemMeta();
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_MATERIAL, (String)name);
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_CLASS, (String)"GAMBESON");
        i.setItemMeta(im);
        return i;
    }

    @Nonnull
    private SlimefunItemStack linksStack(String name) {
        String titName = ThemeUtils.toTitleCase(name);
        return ThemeUtils.themedItemStack("PART_LINKS_" + name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjMxNDAwZjM1YmFlMGNiMmJkZDAzMTRhNDI0ZjEzMDdiNjkyMGJkZmE2ODE0MjczNjUzMGY0OTA0NjNhNTEzYSJ9fX0=", ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " Mail Links", ThemeUtils.PASSIVE + "A set of mail links made of " + titName + ".");
    }

    @Nonnull
    private SlimefunItemStack repairStack(String name) {
        String titName = ThemeUtils.toTitleCase(name);
        return ThemeUtils.themedItemStack("PART_REPAIR_KIT_" + name, Material.CHEST_MINECART, ThemeItemType.PART, this.getColor() + titName + ThemeUtils.ITEM_PART + " Repair Kit", ThemeUtils.PASSIVE + "A kit that is able to repair items", "made out of " + titName + ".");
    }

    private ItemStack[] basicRecipe(ItemStack i, ItemStack i2) {
        return new ItemStack[]{null, null, null, i, null, i2, null, null, null};
    }

    private ItemStack[] bindingRecipe(ItemStack i) {
        return new ItemStack[]{i, null, i, null, i, null, i, null, i};
    }

    private ItemStack[] gambesonRecipe(ItemStack i) {
        return new ItemStack[]{null, i, i, i, null, i, i, i, null};
    }

    @ParametersAreNonnullByDefault
    public void runEvent(TraitEventType type, TraitPartType part, EventFriend friend) {
        switch (part) {
            case HEAD: {
                if (this.traitToolHead == null) break;
                this.traitToolHead.run(type, friend);
                break;
            }
            case BINDER: {
                if (this.traitToolBinder == null) break;
                this.traitToolBinder.run(type, friend);
                break;
            }
            case ROD: {
                if (this.traitToolRod == null) break;
                this.traitToolRod.run(type, friend);
                break;
            }
            case PLATES: {
                if (this.traitArmorPlates == null) break;
                this.traitArmorPlates.run(type, friend);
                break;
            }
            case GAMBESON: {
                if (this.traitArmorGambeson == null) break;
                this.traitArmorGambeson.run(type, friend);
                break;
            }
            case LINKS: {
                if (this.traitArmorLinks == null) break;
                this.traitArmorLinks.run(type, friend);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + part);
            }
        }
    }
}

