/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.templates;

import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class RepairkitTemplate
extends UnplaceableBlock {
    private final String name;
    private String materialType;

    public RepairkitTemplate(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, String name) {
        super(itemGroup, item, recipeType, recipe);
        this.name = name;
    }

    public static boolean isRepairKit(ItemStack itemStack) {
        ItemMeta im = itemStack.getItemMeta();
        String value = PersistentDataAPI.getString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_CLASS);
        return value != null && value.equals("REPAIR");
    }

    public String getName(String material) {
        return ThemeUtils.toTitleCase(material) + ThemeUtils.ITEM_PART + " " + this.name;
    }

    public List<String> getLore(String material, ChatColor color) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        list.add(ThemeUtils.PASSIVE + "A repair kit. Used in the Repair Bench");
        list.add(ThemeUtils.PASSIVE + "to mend tools with a matching head-metal.");
        list.add("");
        list.add(ThemeUtils.CLICK_INFO + "Material : " + color + ThemeUtils.toTitleCase(material));
        return list;
    }

    public ItemStack getStack(String material, String partClass, ChatColor color) {
        ItemStack itemStack = this.getItem().clone();
        itemStack.setType(Material.CHEST_MINECART);
        ItemMeta im = itemStack.getItemMeta();
        im.setLore(this.getLore(material, color));
        im.setDisplayName(color + this.getName(material));
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_MATERIAL, (String)material);
        PersistentDataAPI.setString((PersistentDataHolder)im, (NamespacedKey)Keys.PART_CLASS, (String)partClass);
        itemStack.setItemMeta(im);
        return itemStack;
    }

    public String getName() {
        return this.name;
    }

    public String getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
}

