/*
 * Decompiled with CFR 0.152.
 */
package io.github.sefiraat.slimetinker.items.workstations.armourtable;

import io.github.sefiraat.slimetinker.infinitylib.common.StackUtils;
import io.github.sefiraat.slimetinker.infinitylib.machines.MenuBlock;
import io.github.sefiraat.slimetinker.items.Guide;
import io.github.sefiraat.slimetinker.items.templates.ArmourDefinition;
import io.github.sefiraat.slimetinker.utils.GUIItems;
import io.github.sefiraat.slimetinker.utils.Keys;
import io.github.sefiraat.slimetinker.utils.ThemeUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class ArmourTable
extends MenuBlock {
    protected static final int PREVIEW_SLOT = 38;
    protected static final int CRAFT_BUTTON = 40;
    protected static final int OUTPUT_SLOT = 42;
    private static final int[] BACKGROUND_SLOTS = new int[]{0, 8, 9, 17, 18, 26, 27, 31, 35, 36, 44, 45, 49, 53};
    private static final int[] BACKGROUND_INPUTS = new int[]{1, 3, 5, 7, 10, 12, 14, 16, 19, 20, 21, 22, 23, 24, 25};
    private static final int[] BACKGROUND_PREVIEW = new int[]{28, 29, 30, 37, 39, 46, 47, 48};
    private static final int[] BACKGROUND_OUTPUT = new int[]{32, 33, 34, 41, 43, 50, 51, 52};
    private static final int MARKER_PLATES = 2;
    private static final int MARKER_GAMBESON = 4;
    private static final int MARKER_MAIL_LINK = 6;
    private static final int INPUT_PLATES = 11;
    private static final int INPUT_GAMBESON = 13;
    private static final int INPUT_MAIL_LINK = 15;
    private BlockMenu menu;

    public ArmourTable(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block block, SlimefunItem item, Config data) {
                ArmourTable.this.previewCraft();
            }
        }});
    }

    protected void previewCraft() {
        if (this.menu.hasViewer()) {
            ItemStack plates = this.menu.getItemInSlot(11);
            ItemStack gambeson = this.menu.getItemInSlot(13);
            ItemStack links = this.menu.getItemInSlot(15);
            if (plates == null || gambeson == null || links == null) {
                this.clearPreview();
                return;
            }
            if (!this.validate(plates, gambeson, links)) {
                this.clearPreview();
                return;
            }
            this.menu.replaceExistingItem(38, this.getTool(plates, gambeson, links));
            return;
        }
        this.clearPreview();
    }

    protected void clearPreview() {
        this.menu.replaceExistingItem(38, (ItemStack)GUIItems.MENU_PREVIEW);
    }

    protected ItemStack getTool(ItemStack p, ItemStack g, ItemStack l) {
        ItemStack armour;
        ItemMeta pm = p.getItemMeta();
        ItemMeta gm = g.getItemMeta();
        ItemMeta lm = l.getItemMeta();
        ArmourDefinition armourDefinition = new ArmourDefinition(PersistentDataAPI.getString((PersistentDataHolder)pm, (NamespacedKey)Keys.PART_CLASS), PersistentDataAPI.getString((PersistentDataHolder)pm, (NamespacedKey)Keys.PART_TYPE), PersistentDataAPI.getString((PersistentDataHolder)pm, (NamespacedKey)Keys.PART_MATERIAL), PersistentDataAPI.getString((PersistentDataHolder)gm, (NamespacedKey)Keys.PART_MATERIAL), PersistentDataAPI.getString((PersistentDataHolder)lm, (NamespacedKey)Keys.PART_MATERIAL));
        switch (armourDefinition.getPartType()) {
            case "HELMET": {
                armour = Guide.HELM.getStack(armourDefinition);
                break;
            }
            case "CHESTPLATE": {
                armour = Guide.CHEST.getStack(armourDefinition);
                break;
            }
            case "LEGGINGS": {
                armour = Guide.LEG.getStack(armourDefinition);
                break;
            }
            case "BOOTS": {
                armour = Guide.BOOT.getStack(armourDefinition);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + armourDefinition.getClassType());
            }
        }
        return armour;
    }

    protected boolean validateClass(ItemStack itemStack, String classType) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        if (!itemStack.getItemMeta().getPersistentDataContainer().has(Keys.PART_CLASS, PersistentDataType.STRING)) {
            return false;
        }
        String type = (String)itemStack.getItemMeta().getPersistentDataContainer().get(Keys.PART_CLASS, PersistentDataType.STRING);
        assert (type != null);
        return type.equals(classType);
    }

    protected boolean validateGambeson(ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return false;
        }
        return StackUtils.getIdOrType(itemStack).startsWith("PART_GAMBESON_");
    }

    protected void craft(BlockMenu blockMenu, Player player) {
        ItemStack plates = blockMenu.getItemInSlot(11);
        ItemStack gambeson = blockMenu.getItemInSlot(13);
        ItemStack links = blockMenu.getItemInSlot(15);
        if (plates == null || gambeson == null || links == null) {
            player.sendMessage(ThemeUtils.ERROR + "Not all items present");
            return;
        }
        if (!this.validate(plates, gambeson, links)) {
            player.sendMessage(ThemeUtils.WARNING + "One or more items are either not Tinker's parts or in the wrong slot?");
            return;
        }
        blockMenu.pushItem(this.getTool(plates, gambeson, links).clone(), new int[]{42});
        blockMenu.getItemInSlot(11).setAmount(blockMenu.getItemInSlot(11).getAmount() - 1);
        blockMenu.getItemInSlot(13).setAmount(blockMenu.getItemInSlot(13).getAmount() - 1);
        blockMenu.getItemInSlot(15).setAmount(blockMenu.getItemInSlot(15).getAmount() - 1);
    }

    private boolean validate(ItemStack plates, ItemStack gambeson, ItemStack links) {
        return this.validateClass(plates, "PLATE") && this.validateGambeson(gambeson) && this.validateClass(links, "LINKS");
    }

    @Override
    protected void setup(BlockMenuPreset blockMenuPreset) {
        blockMenuPreset.drawBackground(ChestMenuUtils.getBackground(), BACKGROUND_SLOTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_INPUT, BACKGROUND_INPUTS);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_OUTPUT, BACKGROUND_OUTPUT);
        blockMenuPreset.drawBackground((ItemStack)GUIItems.MENU_BACKGROUND_PREVIEW, BACKGROUND_PREVIEW);
        blockMenuPreset.addItem(40, (ItemStack)GUIItems.MENU_CRAFT_ARMOUR_TABLE);
        blockMenuPreset.addItem(6, (ItemStack)GUIItems.MENU_MARKER_LINKS);
        blockMenuPreset.addItem(4, (ItemStack)GUIItems.MENU_MARKER_GAMBESON);
        blockMenuPreset.addItem(2, (ItemStack)GUIItems.MENU_MARKER_PLATES);
        blockMenuPreset.addItem(38, (ItemStack)GUIItems.MENU_PREVIEW);
        blockMenuPreset.addMenuClickHandler(40, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(6, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(4, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(2, (player, i, itemStack, clickAction) -> false);
        blockMenuPreset.addMenuClickHandler(38, (player, i, itemStack, clickAction) -> false);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[0];
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent event, @Nonnull BlockMenu blockMenu) {
        super.onBreak(event, blockMenu);
        Location location = blockMenu.getLocation();
        blockMenu.dropItems(location, new int[]{11});
        blockMenu.dropItems(location, new int[]{13});
        blockMenu.dropItems(location, new int[]{15});
        blockMenu.dropItems(location, new int[]{42});
    }

    @Override
    protected void onNewInstance(@Nonnull BlockMenu blockMenu, @Nonnull Block b) {
        super.onNewInstance(blockMenu, b);
        this.menu = blockMenu;
        blockMenu.addMenuClickHandler(40, (player, i, itemStack, clickAction) -> {
            this.craft(blockMenu, player);
            return false;
        });
    }
}

