/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud;

import io.github.schntgaispock.bstats.bukkit.Metrics;
import io.github.schntgaispock.bstats.charts.SimplePie;
import io.github.schntgaispock.infinitylib.core.AbstractAddon;
import io.github.schntgaispock.infinitylib.core.AddonConfig;
import io.github.schntgaispock.slimehud.command.CommandManager;
import io.github.schntgaispock.slimehud.placeholder.PlaceholderManager;
import io.github.schntgaispock.slimehud.translation.TranslationManager;
import io.github.schntgaispock.slimehud.waila.HudController;
import io.github.schntgaispock.slimehud.waila.WAILAManager;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class SlimeHUD
extends AbstractAddon {
    AddonConfig playerData;
    static SlimeHUD instance;
    private HudController hudController;
    private TranslationManager translationManager;

    public SlimeHUD() {
        super("SchnTgaiSpock", "SlimeHUD", "master", "options.auto-update");
    }

    @Override
    public void enable() {
        instance = this;
        this.getLogger().info("#=================================#");
        this.getLogger().info("#    SlimeHUD by SchnTgaiSpock    #");
        this.getLogger().info("#=================================#");
        if (this.getConfig().getBoolean("options.auto-update")) {
            if (this.getDescription().getVersion().startsWith("Dev - ")) {
                new BlobBuildUpdater((Plugin)this, this.getFile(), "SlimeHUD", "Dev").start();
            } else {
                this.getLogger().info("This is an unofficial build of SlimeHUD, so auto updates are disabled!");
                this.getLogger().info("You can download the official build here: https://blob.build/project/SlimeHUD");
            }
        }
        Metrics metrics = new Metrics(this, 15883);
        metrics.addCustomChart(new SimplePie("disabled", () -> "" + this.getConfig().getBoolean("waila.disabled")));
        metrics.addCustomChart(new SimplePie("waila_location", () -> this.getConfig().getString("waila.location")));
        this.playerData = new AddonConfig("player.yml");
        WAILAManager.setup();
        CommandManager.setup();
        PlaceholderManager.setup();
        this.hudController = new HudController();
        this.translationManager = new TranslationManager();
    }

    @Override
    public void disable() {
        instance = null;
        this.getPlayerData().save();
    }

    public static HudController getHudController() {
        return SlimeHUD.instance.hudController;
    }

    public static TranslationManager getTranslationManager() {
        return SlimeHUD.instance.translationManager;
    }

    public static NamespacedKey newNamespacedKey(@Nonnull String name) {
        return new NamespacedKey((Plugin)SlimeHUD.getInstance(), name);
    }

    public AddonConfig getPlayerData() {
        return this.playerData;
    }

    public static SlimeHUD getInstance() {
        return instance;
    }
}

