/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.command;

import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.schntgaispock.slimehud.waila.PlayerWAILA;
import io.github.schntgaispock.slimehud.waila.WAILAManager;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SlimeHUDCommandExecutor
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                this.sendInfo(player);
                return true;
            }
            UUID uuid = player.getUniqueId();
            switch (args[0]) {
                case "toggle": {
                    if (!player.hasPermission("slimehud.togglewaila")) {
                        player.sendMessage("\u00a7a\u00a7lSlimeHUD\u00a77> \u00a7cYou don't have permission to toggle your WAILA HUD!");
                        return true;
                    }
                    if (SlimeHUD.getInstance().getConfig().getBoolean("waila.disabled", false)) {
                        player.sendMessage("\u00a7a\u00a7lSlimeHUD\u00a77> \u00a7cThe WAILA HUD is disabled!");
                        return true;
                    }
                    if (SlimeHUD.getInstance().getConfig().getList("waila.disabled-in", Collections.EMPTY_LIST).contains(player.getWorld().getName())) {
                        player.sendMessage("\u00a7a\u00a7lSlimeHUD\u00a77> \u00a7cThe WAILA HUD is disabled in this world!");
                        return true;
                    }
                    boolean wailaOn = SlimeHUD.getInstance().getPlayerData().getBoolean(uuid + ".waila", true);
                    SlimeHUD.getInstance().getPlayerData().set(uuid + ".waila", !wailaOn);
                    Map<UUID, PlayerWAILA> wailas = WAILAManager.getInstance().getWailas();
                    wailas.get(uuid).setPaused(wailaOn);
                    SlimeHUD.getInstance().getPlayerData().save();
                    player.sendMessage("\u00a7a\u00a7lSlimeHUD\u00a77> HUD toggled " + (wailaOn ? "\u00a7coff" : "\u00a7aon"));
                    return true;
                }
            }
        }
        return false;
    }

    private void sendInfo(Player player) {
        player.sendMessage(new String[]{"", "\u00a7a\u00a7lSlimeHUD \u00a77- \u00a72Version " + SlimeHUD.getInstance().getPluginVersion(), "\u00a77------", "\u00a7a\u00a7lWiki \u00a77- \u00a72https://schn.pages.dev/slimehud", "\u00a7a\u00a7lIssues \u00a77- \u00a72https://github.com/SchnTgaiSpock/SlimeHUD/issues", ""});
    }
}

