/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.waila;

import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.schntgaispock.slimehud.util.HudBuilder;
import io.github.schntgaispock.slimehud.util.Util;
import io.github.schntgaispock.slimehud.waila.HudRequest;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNet;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNet;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.CargoConnectorNode;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.CargoManager;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.CargoNode;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.EnergyConnector;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.EnergyRegulator;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.generators.SolarGenerator;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AGenerator;
import org.bukkit.Location;

public class HudController {
    private final Map<Class<?>, Function<HudRequest, String>> defaultHandlers = new LinkedHashMap();
    private final Map<Class<?>, Function<HudRequest, String>> customHandlers = new LinkedHashMap();

    public HudController() {
        this.registerDefaultHandler(MachineProcessHolder.class, this::processMachine);
        this.registerDefaultHandler(AGenerator.class, this::processGenerator);
        this.registerDefaultHandler(SolarGenerator.class, this::processSolarGenerator);
        this.registerDefaultHandler(EnergyRegulator.class, this::processEnergyNode);
        this.registerDefaultHandler(EnergyConnector.class, this::processEnergyNode);
        this.registerDefaultHandler(EnergyNetComponent.class, this::processCapacitor);
        this.registerDefaultHandler(CargoNode.class, this::processCargoNode);
        this.registerDefaultHandler(CargoConnectorNode.class, this::processCargoManagerConnector);
        this.registerDefaultHandler(CargoManager.class, this::processCargoManagerConnector);
    }

    @Nonnull
    private String processEnergyNode(@Nonnull HudRequest request) {
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-energy-size")) {
            return "";
        }
        EnergyNet en = EnergyNet.getNetworkFromLocation((Location)request.getLocation());
        int size = this.getNetworkSize((Network)en);
        return size < 0 ? "" : "Network Size: " + HudBuilder.getCommaNumber(size);
    }

    @Nonnull
    private String processCapacitor(@Nonnull HudRequest request) {
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-energy-stored")) {
            return "";
        }
        EnergyNetComponent enc = (EnergyNetComponent)request.getSlimefunItem();
        EnergyNetComponentType enct = enc.getEnergyComponentType();
        if ((enct == EnergyNetComponentType.CAPACITOR || enct == EnergyNetComponentType.GENERATOR || enct == EnergyNetComponentType.CONSUMER) && enc.getCapacity() > 0) {
            return HudBuilder.formatEnergyStored(enc.getCharge(request.getLocation()), enc.getCapacity());
        }
        return "";
    }

    @Nonnull
    private String processMachine(@Nonnull HudRequest request) {
        StringBuilder hudText = new StringBuilder();
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-machine-progress")) {
            return "";
        }
        MachineProcessHolder machine = (MachineProcessHolder)request.getSlimefunItem();
        MachineOperation operation = machine.getMachineProcessor().getOperation(request.getLocation());
        if (operation == null) {
            hudText.append("Idle");
            if (request.getSlimefunItem() instanceof EnergyNetComponent) {
                hudText.append(" ").append(this.processCapacitor(request));
            }
            return hudText.toString();
        }
        int progress = operation.getProgress();
        int total = operation.getTotalTicks();
        hudText.append(HudBuilder.formatProgressBar(progress, total));
        if (request.getSlimefunItem() instanceof AGenerator) {
            hudText.append(" ").append(this.processGenerator(request));
        }
        return hudText.toString();
    }

    @Nonnull
    private String processGenerator(@Nonnull HudRequest request) {
        StringBuilder hudText = new StringBuilder();
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-generator-generation")) {
            return "";
        }
        AGenerator gen = (AGenerator)request.getSlimefunItem();
        int generation = gen.getEnergyProduction();
        if (generation > 0) {
            hudText.append(HudBuilder.formatEnergyGenerated(generation));
        } else {
            hudText.append("Not generating");
        }
        if (gen instanceof EnergyNetComponent) {
            hudText.append(" ").append(this.processCapacitor(request));
        }
        return hudText.toString();
    }

    @Nonnull
    private String processSolarGenerator(@Nonnull HudRequest request) {
        StringBuilder hudText = new StringBuilder();
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-generator-generation")) {
            return "";
        }
        SolarGenerator gen = (SolarGenerator)request.getSlimefunItem();
        int generation = gen.getGeneratedOutput(request.getLocation(), null);
        if (generation > 0) {
            hudText.append(HudBuilder.formatEnergyGenerated(generation));
        } else {
            hudText.append("Not generating");
        }
        if (gen instanceof EnergyNetComponent) {
            hudText.append(" ").append(this.processCapacitor(request));
        }
        return hudText.toString();
    }

    @Nonnull
    private String processCargoNode(@Nonnull HudRequest request) {
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-cargo-channel")) {
            return "";
        }
        CargoNode cn = (CargoNode)request.getSlimefunItem();
        int channel = cn.getSelectedChannel(request.getLocation().getBlock()) + 1;
        return "Channel: " + Util.getColorFromCargoChannel(channel).toString() + channel;
    }

    @Nonnull
    private String processCargoManagerConnector(@Nonnull HudRequest request) {
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.show-cargo-size")) {
            return "";
        }
        CargoNet cn = CargoNet.getNetworkFromLocation((Location)request.getLocation());
        int size = this.getNetworkSize((Network)cn);
        return size < 0 ? "" : "Network Size: " + HudBuilder.getCommaNumber(size);
    }

    private int getNetworkSize(Network network) {
        if (network != null) {
            try {
                Field con = Network.class.getDeclaredField("connectorNodes");
                Field ter = Network.class.getDeclaredField("terminusNodes");
                con.setAccessible(true);
                ter.setAccessible(true);
                int conSize = ((Set)con.get(network)).size();
                int terSize = ((Set)ter.get(network)).size();
                con.setAccessible(false);
                ter.setAccessible(false);
                return conSize + terSize + 1;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @Nullable
    private Function<HudRequest, String> tryGetHandler(@Nonnull SlimefunItem slimefunItem) {
        for (Map.Entry<Class<?>, Function<HudRequest, String>> entry : this.customHandlers.entrySet()) {
            if (!entry.getKey().isInstance(slimefunItem)) continue;
            return entry.getValue();
        }
        for (Map.Entry<Class<?>, Function<HudRequest, String>> entry : this.defaultHandlers.entrySet()) {
            if (!entry.getKey().isInstance(slimefunItem)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nonnull
    public String processRequest(@Nonnull HudRequest request) {
        Function<HudRequest, String> handler = this.tryGetHandler(request.getSlimefunItem());
        if (handler == null) {
            return "";
        }
        String ret = handler.apply(request);
        return ret == null ? "" : ret;
    }

    @ParametersAreNonnullByDefault
    private void registerDefaultHandler(Class<?> clazz, Function<HudRequest, String> handler) {
        this.defaultHandlers.put(clazz, handler);
    }

    @ParametersAreNonnullByDefault
    public void registerCustomHandler(Class<?> clazz, Function<HudRequest, String> handler) {
        this.customHandlers.put(clazz, handler);
    }
}

