/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.translation;

import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.api.SlimefunTranslationAPI;
import net.guizhanss.slimefuntranslation.core.users.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TranslationManager {
    private boolean translationEnabled;

    public TranslationManager() {
        if (SlimeHUD.getInstance().getConfig().getBoolean("options.slimefun-translation-support", true)) {
            if (Bukkit.getPluginManager().getPlugin("SlimefunTranslation") != null) {
                this.translationEnabled = true;
            } else {
                SlimeHUD.getInstance().getLogger().info("SlimefunTranslation is not installed and has been ignored.");
                this.translationEnabled = false;
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String getItemName(Player p, SlimefunItem sfItem) {
        if (!this.translationEnabled) {
            return sfItem.getItemName();
        }
        try {
            return SlimefunTranslationAPI.getItemName((User)SlimefunTranslationAPI.getUser((Player)p), (SlimefunItem)sfItem);
        }
        catch (NoClassDefFoundError e) {
            SlimeHUD.getInstance().getLogger().info("Could not get item translation! Please update SlimefunTranslation");
            this.translationEnabled = false;
            return sfItem.getItemName();
        }
    }
}

