/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.waila;

import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.schntgaispock.slimehud.waila.PlayerWAILA;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class WAILAManager
implements Listener {
    private static WAILAManager instance;
    private Map<UUID, PlayerWAILA> wailas = new HashMap<UUID, PlayerWAILA>();

    private WAILAManager() {
    }

    public static WAILAManager getInstance() {
        if (instance == null) {
            instance = new WAILAManager();
        }
        return instance;
    }

    private void generateWAILA(@Nonnull Player player) {
        PlayerWAILA waila;
        if (!this.wailas.containsKey(player.getUniqueId())) {
            waila = new PlayerWAILA(player);
            waila.runTaskTimer((Plugin)SlimeHUD.getInstance(), 0L, SlimeHUD.getInstance().getConfig().getLong("waila.tick-rate"));
            this.wailas.put(player.getUniqueId(), waila);
        } else {
            waila = this.wailas.get(player.getUniqueId());
        }
        waila.setPaused(!SlimeHUD.getInstance().getPlayerData().getBoolean(player.getUniqueId().toString() + ".waila", true));
    }

    private void pauseWAILA(Player player) {
        PlayerWAILA waila = this.wailas.get(player.getUniqueId());
        if (waila != null) {
            waila.setPaused(true);
        }
    }

    private void removeWAILA(Player player) {
        PlayerWAILA waila = this.wailas.remove(player.getUniqueId());
        if (waila != null) {
            waila.cancel();
        }
    }

    @EventHandler
    public void onPlayerJoin(@Nonnull PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (!SlimeHUD.getInstance().getConfig().getBoolean("waila.disabled", false) && !SlimeHUD.getInstance().getConfig().getList("waila.disabled-in", Collections.EMPTY_LIST).contains(player.getWorld().getName())) {
            this.generateWAILA(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(@Nonnull PlayerQuitEvent e) {
        this.removeWAILA(e.getPlayer());
    }

    @EventHandler
    public void onPlayerChangeWorld(@Nonnull PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        if (SlimeHUD.getInstance().getConfig().getList("waila.disabled-in", Collections.EMPTY_LIST).contains(player.getWorld().getName())) {
            this.pauseWAILA(player);
        } else {
            this.generateWAILA(player);
        }
    }

    public static void setup() {
        Bukkit.getPluginManager().registerEvents((Listener)WAILAManager.getInstance(), (Plugin)SlimeHUD.getInstance());
    }

    public Map<UUID, PlayerWAILA> getWailas() {
        return this.wailas;
    }
}

