/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.waila;

import io.github.schntgaispock.slimehud.SlimeHUD;
import io.github.schntgaispock.slimehud.util.Util;
import io.github.schntgaispock.slimehud.waila.HudRequest;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerWAILA
extends BukkitRunnable {
    @Nonnull
    private final Player player;
    private final BossBar WAILABar;
    private final String WAILALocation = SlimeHUD.getInstance().getConfig().getString("waila.location");
    private final boolean useAutoBossBarColor;
    private final boolean keepTextColors;
    private String previousFacing = "";
    private boolean paused;

    public PlayerWAILA(@Nonnull Player player) {
        this.player = player;
        String bossbarColor = SlimeHUD.getInstance().getConfig().getString("waila.bossbar-color").trim().toLowerCase();
        this.useAutoBossBarColor = bossbarColor.equals("inherit");
        this.WAILABar = Bukkit.createBossBar((String)"", (BarColor)Util.pickBarColorFromColor(bossbarColor), (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.WAILABar.addPlayer(player);
        this.WAILABar.setVisible(false);
        this.keepTextColors = SlimeHUD.getInstance().getConfig().getBoolean("waila.use-original-colors");
    }

    public String getFacing() {
        Block targetBlock = this.player.getTargetBlockExact(5);
        if (targetBlock == null) {
            return "";
        }
        Location target = targetBlock.getLocation();
        if (target == null) {
            return "";
        }
        SlimefunItem item = BlockStorage.check((Block)targetBlock);
        if (item == null) {
            return "";
        }
        HudRequest request = new HudRequest(item, target, this.player);
        StringBuilder text = new StringBuilder(SlimeHUD.getTranslationManager().getItemName(this.player, item)).append(" ").append(ChatColor.translateAlternateColorCodes((char)'&', (String)SlimeHUD.getHudController().processRequest(request)));
        return text.toString();
    }

    public void run() {
        if (this.isPaused()) {
            return;
        }
        String facing = this.getFacing();
        if (facing.equals(this.previousFacing)) {
            return;
        }
        this.previousFacing = facing;
        switch (this.WAILALocation) {
            case "bossbar": {
                if (facing.equals("")) {
                    this.WAILABar.setVisible(false);
                    break;
                }
                this.WAILABar.setVisible(true);
                this.WAILABar.setTitle(this.keepTextColors ? facing : ChatColor.stripColor((String)facing));
                if (!this.useAutoBossBarColor) break;
                this.WAILABar.setColor(Util.pickBarColorFromName(facing));
                break;
            }
            case "hotbar": {
                this.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(facing));
                break;
            }
        }
    }

    public void setPaused(boolean paused) {
        this.setVisible(!this.previousFacing.equals("") && !paused);
        this.paused = paused;
    }

    public PlayerWAILA setVisible(boolean visible) {
        this.WAILABar.setVisible(visible);
        return this;
    }

    public int hashCode() {
        return this.getPlayer().hashCode();
    }

    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    public BossBar getWAILABar() {
        return this.WAILABar;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

