/*
 * Decompiled with CFR 0.152.
 */
package io.github.schntgaispock.slimehud.util;

import io.github.schntgaispock.slimehud.SlimeHUD;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.boss.BarColor;

public final class Util {
    private static HashMap<RGB, BarColor> barColorRGBMap = new HashMap();
    private static HashMap<RGB, BarColor> savedBarColors = new HashMap();

    public static BarColor pickBarColorFromName(String name) {
        int colorCode;
        int n = colorCode = name.trim().toLowerCase().startsWith("\u00a7") ? (int)name.charAt(1) : 32;
        if (colorCode == 120) {
            try {
                String stripped = name.replace("\u00a7", "");
                int red = Integer.parseInt(stripped, 1, 3, 16);
                int green = Integer.parseInt(stripped, 3, 5, 16);
                int blue = Integer.parseInt(stripped, 5, 7, 16);
                RGB rgb = new RGB(red, green, blue);
                if (savedBarColors.containsKey(rgb)) {
                    return savedBarColors.get(rgb);
                }
                BarColor color = barColorRGBMap.get(Collections.min(barColorRGBMap.keySet(), (a, b) -> Util.errorSquared(a.asArray(), rgb.asArray()) < Util.errorSquared(b.asArray(), rgb.asArray()) ? -1 : 1));
                savedBarColors.put(rgb, color);
                return color;
            }
            catch (NumberFormatException e) {
                return BarColor.WHITE;
            }
        }
        return switch (colorCode) {
            case 52, 99 -> BarColor.RED;
            case 54, 101 -> BarColor.YELLOW;
            case 50, 97 -> BarColor.GREEN;
            case 51, 98 -> BarColor.BLUE;
            case 49, 53, 57 -> BarColor.PURPLE;
            case 100 -> BarColor.PINK;
            default -> BarColor.WHITE;
        };
    }

    public static BarColor pickBarColorFromColor(String color) {
        switch (color.trim()) {
            case "red": 
            case "yellow": 
            case "green": 
            case "blue": 
            case "purple": 
            case "pink": 
            case "white": {
                return BarColor.valueOf((String)color.toUpperCase());
            }
            case "default": 
            case "inherit": {
                return BarColor.WHITE;
            }
        }
        SlimeHUD.log(Level.WARNING, "[SlimeHUD] Invalid bossbar color: " + color, "[SlimeHUD] Setting color to white...");
        return BarColor.WHITE;
    }

    public static ChatColor getColorFromCargoChannel(int channel) {
        switch (channel) {
            case 1: {
                return ChatColor.WHITE;
            }
            case 2: {
                return ChatColor.GOLD;
            }
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.AQUA;
            }
            case 5: {
                return ChatColor.YELLOW;
            }
            case 6: {
                return ChatColor.GREEN;
            }
            case 7: {
                return ChatColor.LIGHT_PURPLE;
            }
            case 8: {
                return ChatColor.DARK_GRAY;
            }
            case 9: {
                return ChatColor.GRAY;
            }
            case 10: {
                return ChatColor.DARK_AQUA;
            }
            case 11: {
                return ChatColor.DARK_PURPLE;
            }
            case 12: {
                return ChatColor.DARK_BLUE;
            }
            case 13: {
                return ChatColor.RED;
            }
            case 14: {
                return ChatColor.DARK_GREEN;
            }
            case 15: {
                return ChatColor.DARK_RED;
            }
            case 16: {
                return ChatColor.BLACK;
            }
        }
        return ChatColor.WHITE;
    }

    public static int errorSquared(int[] a, int[] b) {
        if (a.length != b.length) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        for (int i = 0; i < a.length; ++i) {
            total += (int)Math.pow(a[i] - b[i], 2.0);
        }
        return total;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        barColorRGBMap.put(new RGB(0, 185, 236), BarColor.BLUE);
        barColorRGBMap.put(new RGB(22, 185, 0), BarColor.GREEN);
        barColorRGBMap.put(new RGB(185, 0, 144), BarColor.PINK);
        barColorRGBMap.put(new RGB(97, 0, 185), BarColor.PURPLE);
        barColorRGBMap.put(new RGB(185, 42, 0), BarColor.RED);
        barColorRGBMap.put(new RGB(255, 255, 255), BarColor.WHITE);
        barColorRGBMap.put(new RGB(185, 185, 0), BarColor.YELLOW);
    }

    private static class RGB {
        private final int red;
        private final int green;
        private final int blue;

        public int[] asArray() {
            return new int[]{this.red, this.green, this.blue};
        }

        public RGB(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RGB)) {
                return false;
            }
            RGB other = (RGB)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRed() != other.getRed()) {
                return false;
            }
            if (this.getGreen() != other.getGreen()) {
                return false;
            }
            return this.getBlue() == other.getBlue();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RGB;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRed();
            result = result * 59 + this.getGreen();
            result = result * 59 + this.getBlue();
            return result;
        }

        public String toString() {
            return "Util.RGB(red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ")";
        }
    }
}

